/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.geo.twin.clients.publicity;

import cn.gtmap.ias.geo.twin.domain.dto.PageDataDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceQueryDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceTypeDto;
import cn.gtmap.ias.geo.twin.domain.dto.ThemeDto;
import cn.gtmap.ias.geo.twin.domain.dto.page.LayPage;
import cn.gtmap.ias.geo.twin.domain.dto.page.LayPageable;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.twin.name}")
@RequestMapping(value={"${app.feign-client.twin.context-path}/public/resource/resource"})
public interface ResourcePublicClient {
    @GetMapping(value={"/theme/list"})
    public List<ThemeDto> getThemeDtoList();

    @GetMapping(value={"/type"})
    public List<ResourceTypeDto> getResourceTypeDtoListByStyle(@RequestParam(name="typeStyle") String var1);

    @GetMapping(value={"/all/type"})
    public List<ResourceTypeDto> getResourceTypeDtoList();

    @GetMapping(value={"/resources"})
    public PageDataDto getResourceListForPage(@RequestBody ResourceQueryDto var1, @RequestParam(name="groupIds", required=true) String[] var2);

    @GetMapping(value={"/all/resource"})
    public LayPage<ResourceDto> findAllResource(@RequestBody LayPageable var1, @RequestParam(name="instanceType") String var2, @RequestParam(name="typeId") String var3);

    @GetMapping(value={"/resource/{id}"})
    public ResourceDto getResourceDtoById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/resource/useAble"})
    public int useAble(@RequestParam(name="userName") String var1, @RequestParam(name="id") String var2);

    @GetMapping(value={"/resource/user/{id}"})
    public ResourceDto getResourceDtoByIdAndUser(@PathVariable(name="id") String var1, @RequestParam(name="userName") String var2, @RequestParam(name="orgId") String var3);

    @GetMapping(value={"/count"})
    public long getResourceCountByKeyWord(@RequestParam(name="keyword") String var1);

    @GetMapping(value={"/findByKeyWord"})
    public LayPage<ResourceDto> findByKeyWord(@RequestBody LayPageable var1, @RequestParam(name="keyword") String var2);

    @GetMapping(value={"/all/count"})
    public long getResourceAllCounts();

    @GetMapping(value={"/all/access/count"})
    public long getAllResourceAccessCounts();
}

