/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.search.engine.manager.impl;

import cn.gtmap.ias.search.engine.cfg.IKAnalyzer;
import cn.gtmap.ias.search.engine.exception.LuceneSearchException;
import cn.gtmap.ias.search.engine.manager.SearchEngine;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.spatial3d.Geo3DDocValuesField;
import org.apache.lucene.spatial3d.Geo3DPoint;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineImpl
implements SearchEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int GEO_HASH_MAX_LEVELS = 11;
    private static final boolean IK_USE_SMART = true;

    @Override
    public void create(List<Document> documents, String luceneIndexDir) {
        IndexWriter indexWriter = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            IKAnalyzer analyzer = new IKAnalyzer(true);
            IndexWriterConfig conf = new IndexWriterConfig((Analyzer)analyzer);
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriter = new IndexWriter((Directory)directory, conf);
            indexWriter.addDocuments(documents);
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    @Override
    public void update(Term term, Document document, String luceneIndexDir) {
        IndexWriter indexWriter = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new IKAnalyzer(true));
            indexWriter = new IndexWriter((Directory)directory, conf);
            indexWriter.updateDocument(term, (Iterable)document);
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    @Override
    public void delete(Term term, String luceneIndexDir) {
        IndexWriter indexWriter = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new IKAnalyzer(true));
            indexWriter = new IndexWriter((Directory)directory, conf);
            if (term == null) {
                indexWriter.deleteAll();
            } else {
                indexWriter.deleteDocuments(new Term[]{term});
            }
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    @Override
    public List<Map<String, Object>> search(String[] fields, String keyword, int count, String luceneIndexDir) {
        keyword = this.processKeyword(keyword);
        TopDocs topDocs = null;
        DirectoryReader indexReader = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            BooleanClause.Occur[] clauses = new BooleanClause.Occur[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                clauses[i] = BooleanClause.Occur.SHOULD;
            }
            Query query = MultiFieldQueryParser.parse((String)keyword, (String[])fields, (BooleanClause.Occur[])clauses, (Analyzer)new IKAnalyzer(true));
            topDocs = indexSearcher.search(query, count);
            this.logger.info("\u5f53\u524d\u641c\u7d22\u5230{}\u6761\u6570\u636e", (Object)topDocs.totalHits);
            if (topDocs.totalHits == 0) {
                List<Map<String, Object>> list = null;
                return list;
            }
            List<Map<String, Object>> list = this.assign(topDocs, (IndexReader)indexReader);
            return list;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        catch (ParseException e) {
            throw new LuceneSearchException("\u89e3\u6790\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff1a" + keyword, e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    private String processKeyword(String keyword) {
        return keyword.replace("(", "\uff08").replace(")", "\uff09").replace("{", "\uff08").replace("}", "\uff09").replace("[", "").replace("]", "").replace("'", "").replace("\u2018", "\u201c").replace("\u2019", "\u201d").replace("/", "");
    }

    @Override
    public List<Map<String, Object>> search(String luceneIndexDir, Integer count) {
        DirectoryReader indexReader = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            if (count == null) {
                count = indexReader.maxDoc();
            } else if (count > indexReader.maxDoc()) {
                count = indexReader.maxDoc();
            }
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < count; ++i) {
                Document document = indexSearcher.doc(i);
                List fields = document.getFields();
                HashMap map = new HashMap();
                fields.stream().forEach(field -> map.put(field.name(), field.stringValue()));
                data.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = data;
            return arrayList;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    private List<Map<String, Object>> assign(TopDocs topDocs, IndexReader indexReader) {
        ScoreDoc[] scoreDocs;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            int docID = scoreDoc.doc;
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("document", indexReader.document(docID));
                data.put("score", Float.valueOf(scoreDoc.score));
                result.add(data);
            }
            catch (IOException e) {
                throw new LuceneSearchException("\u6839\u636e\u6587\u6863\u7f16\u53f7\u627e\u6587\u6863\u51fa\u9519\uff0c" + docID, e);
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> searchSpatial(String fieldName, double longitude, double latitude, int count, String luceneIndexDir) {
        DirectoryReader indexReader = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            Query query = Geo3DPoint.newDistanceQuery((String)fieldName, (double)latitude, (double)longitude, (double)1000.0);
            Sort distSort = new Sort(Geo3DDocValuesField.newDistanceSort((String)fieldName, (double)latitude, (double)longitude, (double)6378137.0));
            TopFieldDocs topdocs = indexSearcher.search(query, count, distSort);
            List<Map<String, Object>> list = this.assign((TopDocs)topdocs, (IndexReader)indexReader);
            return list;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }

    @Override
    public List<String> analyze(String text, boolean useSmart) {
        IKAnalyzer analyzer = new IKAnalyzer(useSmart);
        ArrayList<String> words = new ArrayList<String>();
        try {
            TokenStream tokenStream = analyzer.tokenStream("address", new StringReader(text));
            tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                words.add(charTermAttribute.toString());
                System.out.println(charTermAttribute.toString());
            }
            tokenStream.end();
            tokenStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return words;
    }

    @Override
    public int getTotal(String luceneIndexDir) {
        DirectoryReader indexReader = null;
        try {
            Path path = Paths.get(luceneIndexDir, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            MatchAllDocsQuery query = new MatchAllDocsQuery();
            TopDocs topDocs = indexSearcher.search((Query)query, 1);
            this.logger.info("\u5f53\u524d\u641c\u7d22\u5230{}\u6761\u6570\u636e", (Object)topDocs.totalHits);
            int n = topDocs.totalHits;
            return n;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(luceneIndexDir), e);
                }
            }
        }
    }
}

