/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.search.engine.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.wltea.analyzer.cfg.Configuration;

public class IKAnalyzerConfiguration
implements Configuration {
    private static final String PATH_DIC_MAIN = "org/wltea/analyzer/dic/main2012.dic";
    private static final String PATH_DIC_QUANTIFIER = "org/wltea/analyzer/dic/quantifier.dic";
    private static final String FILE_NAME = "IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private Properties props = new Properties();
    private boolean useSmart;

    public static Configuration getInstance() {
        return new IKAnalyzerConfiguration();
    }

    private IKAnalyzerConfiguration() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(FILE_NAME);
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (InvalidPropertiesFormatException var3) {
                var3.printStackTrace();
            }
            catch (IOException var4) {
                var4.printStackTrace();
            }
        }
    }

    public boolean useSmart() {
        return this.useSmart;
    }

    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public String getMainDictionary() {
        return PATH_DIC_MAIN;
    }

    public String getQuantifierDicionary() {
        return PATH_DIC_QUANTIFIER;
    }

    public List<String> getExtDictionarys() {
        String[] filePaths;
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.props.getProperty(EXT_DICT);
        if (extDictCfg != null && (filePaths = extDictCfg.split(";")) != null) {
            String[] var4 = filePaths;
            int var5 = filePaths.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String filePath = var4[var6];
                if (filePath == null || "".equals(filePath.trim())) continue;
                extDictFiles.add(filePath.trim());
            }
        }
        return extDictFiles;
    }

    public List<String> getExtStopWordDictionarys() {
        String[] filePaths;
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.props.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null && (filePaths = extStopWordDictCfg.split(";")) != null) {
            String[] var4 = filePaths;
            int var5 = filePaths.length;
            String userDir = System.getProperty("user.dir");
            System.out.println(userDir);
            for (int var6 = 0; var6 < var5; ++var6) {
                String filePath = var4[var6];
                if (filePath == null || "".equals(filePath.trim())) continue;
                extStopWordDictFiles.add(userDir + "/" + filePath.trim());
            }
        }
        return extStopWordDictFiles;
    }
}

