/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.search.engine.cfg;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.wltea.analyzer.cfg.Configuration;

public class IKAnalyzerConfig
implements Configuration {
    private static final String PATH_DIC_MAIN = "./cfg/dic/main2012.dic";
    private static final String PATH_DIC_QUANTIFIER = "./cfg/dic/quantifier.dic";
    private static final String FILE_NAME = "./cfg/dic/IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private Properties props = new Properties();
    private boolean useSmart;

    public static Configuration getInstance() {
        return new IKAnalyzerConfig();
    }

    private IKAnalyzerConfig() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(FILE_NAME);
        if (input == null) {
            try {
                input = new FileInputStream(FILE_NAME);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (InvalidPropertiesFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean useSmart() {
        return this.useSmart;
    }

    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public String getMainDictionary() {
        return PATH_DIC_MAIN;
    }

    public String getQuantifierDicionary() {
        return PATH_DIC_QUANTIFIER;
    }

    public List<String> getExtDictionarys() {
        String[] filePaths;
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.props.getProperty(EXT_DICT);
        if (extDictCfg != null && (filePaths = extDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extDictFiles.add(filePath.trim());
            }
        }
        return extDictFiles;
    }

    public List<String> getExtStopWordDictionarys() {
        String[] filePaths;
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.props.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null && (filePaths = extStopWordDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extStopWordDictFiles.add(filePath.trim());
            }
        }
        return extStopWordDictFiles;
    }
}

