/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.search.engine.manager.impl;

import cn.gtmap.ias.search.engine.exception.LuceneSearchException;
import cn.gtmap.ias.search.engine.manager.SearchEngine;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class SearchEngineImpl
implements SearchEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${lucene.index.directory}")
    private String luceneIndexDir;
    private static final String LUCENE_INDEX_DIR = "/";
    private static final int GEO_HASH_MAX_LEVELS = 11;

    @Override
    public void create(List<Document> documents) {
        IndexWriter indexWriter = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            IKAnalyzer analyzer = new IKAnalyzer(true);
            IndexWriterConfig conf = new IndexWriterConfig(Version.LATEST, (Analyzer)analyzer);
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            indexWriter = new IndexWriter((Directory)directory, conf);
            indexWriter.addDocuments(documents);
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }

    @Override
    public void update(Term term, Document document) {
        IndexWriter indexWriter = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            IndexWriterConfig conf = new IndexWriterConfig(Version.LATEST, (Analyzer)new IKAnalyzer(true));
            indexWriter = new IndexWriter((Directory)directory, conf);
            indexWriter.updateDocument(term, (Iterable)document);
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }

    @Override
    public void delete(Term term) {
        IndexWriter indexWriter = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            IndexWriterConfig conf = new IndexWriterConfig(Version.LATEST, (Analyzer)new IKAnalyzer(true));
            indexWriter = new IndexWriter((Directory)directory, conf);
            if (term == null) {
                indexWriter.deleteAll();
            } else {
                indexWriter.deleteDocuments(new Term[]{term});
            }
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }

    @Override
    public List<Map<String, Object>> search(String[] fields, String keyword, int count) {
        TopDocs topDocs = null;
        DirectoryReader indexReader = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            BooleanClause.Occur[] clauses = new BooleanClause.Occur[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                clauses[i] = BooleanClause.Occur.SHOULD;
            }
            Query query = MultiFieldQueryParser.parse((Version)Version.LATEST, (String)keyword, (String[])fields, (BooleanClause.Occur[])clauses, (Analyzer)new IKAnalyzer(true));
            topDocs = indexSearcher.search(query, count);
            this.logger.info("\u5f53\u524d\u641c\u7d22\u5230{}\u6761\u6570\u636e", (Object)topDocs.totalHits);
            if (topDocs.totalHits == 0) {
                List<Map<String, Object>> list = null;
                return list;
            }
            List<Map<String, Object>> list = this.assign(topDocs, (IndexReader)indexReader);
            return list;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        catch (ParseException e) {
            throw new LuceneSearchException("\u89e3\u6790\u641c\u7d22\u6761\u4ef6\u51fa\u9519", e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }

    @Override
    public List<Map<String, Object>> search() {
        DirectoryReader indexReader = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            int count = indexReader.maxDoc();
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < count; ++i) {
                Document document = indexSearcher.doc(i);
                List fields = document.getFields();
                HashMap map = new HashMap();
                fields.stream().forEach(field -> map.put(field.name(), field.stringValue()));
                data.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = data;
            return arrayList;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }

    private List<Map<String, Object>> assign(TopDocs topDocs, IndexReader indexReader) {
        ScoreDoc[] scoreDocs;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            int docID = scoreDoc.doc;
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("document", indexReader.document(docID));
                data.put("score", Float.valueOf(scoreDoc.score));
                result.add(data);
            }
            catch (IOException e) {
                throw new LuceneSearchException("\u6839\u636e\u6587\u6863\u7f16\u53f7\u627e\u6587\u6863\u51fa\u9519\uff0c" + docID, e);
            }
        }
        return result;
    }

    public String getLuceneIndexDir() {
        if (StringUtils.isEmpty((Object)this.luceneIndexDir)) {
            return LUCENE_INDEX_DIR;
        }
        return this.luceneIndexDir;
    }

    @Override
    public List<Map<String, Object>> searchSpatial(String fieldName, double longitude, double latitude, int count) {
        SpatialContext spatialContext = SpatialContext.GEO;
        GeohashPrefixTree spatialPrefixTree = new GeohashPrefixTree(spatialContext, 11);
        RecursivePrefixTreeStrategy strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)spatialPrefixTree, fieldName);
        DirectoryReader indexReader = null;
        try {
            FSDirectory directory = FSDirectory.open((File)new File(this.getLuceneIndexDir()));
            indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            Point point = spatialContext.makePoint(longitude, latitude);
            ValueSource valueSource = strategy.makeDistanceValueSource(point, 111.19507973436875);
            Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(indexSearcher);
            TopFieldDocs topdocs = indexSearcher.search((Query)new MatchAllDocsQuery(), count, distSort);
            List<Map<String, Object>> list = this.assign((TopDocs)topdocs, (IndexReader)indexReader);
            return list;
        }
        catch (IOException e) {
            throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    throw new LuceneSearchException("lucene\u7d22\u5f15\u76ee\u5f55\u4e0d\u80fd\u8bbf\u95ee\uff0c".concat(this.getLuceneIndexDir()), e);
                }
            }
        }
    }
}

