/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.geo.twin.clients;

import cn.gtmap.ias.geo.twin.bean.ResourceAccessBean;
import cn.gtmap.ias.geo.twin.bean.ResourceBean;
import cn.gtmap.ias.geo.twin.domain.dto.PageDataDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceAccessDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceApplyDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceCountDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceQueryDto;
import cn.gtmap.ias.geo.twin.domain.dto.ThemeDto;
import cn.gtmap.ias.geo.twin.domain.dto.page.LayPage;
import cn.gtmap.ias.geo.twin.domain.dto.page.LayPageable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.twin.name}")
@RequestMapping(value={"${app.feign-client.twin.context-path}/resource/resource"})
public interface ResourceClient {
    @GetMapping(value={"/getThemeById"})
    public ThemeDto getThemeDtoById(@RequestParam(name="themeId") String var1);

    @PostMapping(value={"/saveResourceDto"})
    public ResourceDto saveResourceDto(@RequestBody ResourceDto var1);

    @PostMapping(value={"/saveTheme"})
    public ThemeDto saveTheme(@RequestBody ThemeDto var1);

    @PostMapping(value={"/saveResourceApply"})
    public ResourceApplyDto saveResourceApply(@RequestBody ResourceApplyDto var1);

    @GetMapping(value={"/themeGrid"})
    public PageDataDto getThemeListForPage(@RequestParam(name="page") String var1, @RequestParam(name="rows") String var2);

    @PostMapping(value={"/deleteTheme"})
    public void deleteThemeDto(@RequestBody ThemeDto var1);

    @GetMapping(value={"/resourceApplyGrid"})
    public PageDataDto getResourceApplyForPage(@RequestParam(name="page") String var1, @RequestParam(name="rows") String var2);

    @PostMapping(value={"/updateThemeStatus"})
    public int updateThemeStatusByThemeId(@RequestBody ThemeDto var1);

    @GetMapping(value={"/examine/page"})
    public LayPage<ResourceApplyDto> getResourceApplyForPage(@RequestBody LayPageable var1, @RequestParam(name="isAdmin") boolean var2, @RequestParam(name="userName") String var3);

    @GetMapping(value={"/theme/page"})
    public LayPage<ThemeDto> themePage(@RequestBody LayPageable var1);

    @PatchMapping(value={"/examine/{status}"})
    public void updateResourceApplyStatus(@PathVariable(name="status") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/resource/{id}"})
    public ResourceDto getResourceDtoById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/resource/{username}/{status}"})
    public LayPage<ResourceApplyDto> findResourceApplyForPage(@RequestBody LayPageable var1, @PathVariable(name="username") String var2, @PathVariable(name="status") String var3);

    @GetMapping(value={"/getResourceCount"})
    public ResourceCountDto getResourceCounts();

    @GetMapping(value={"/resource/all/{username}"})
    public LayPage<ResourceDto> findResourceForPage(@RequestBody LayPageable var1, @PathVariable(name="username") String var2);

    @PutMapping(value={"/delete/{id}"})
    public void deleteById(@PathVariable(name="id") String var1);

    @DeleteMapping(value={"/theme/delete/{id}"})
    public void deleteThemeById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/resourceApply/{id}"})
    public ResourceApplyDto getResourceApplyById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/applied/{username}"})
    public List<ResourceAccessBean> getAppliedCount(@PathVariable(name="username") String var1);

    @GetMapping(value={"/type/applied"})
    public List<ResourceAccessBean> getAppliedCountByResourceType(@RequestParam(name="username") String var1, @RequestParam(name="resourcetype") String var2);

    @GetMapping(value={"/getResourceCountsByUrl"})
    public int getResourceCountsByUrl(@RequestParam(name="resUrl") String var1);

    @GetMapping(value={"/count/{username}"})
    public List<ResourceBean> getResourceCountByUserName(@PathVariable(name="username") String var1);

    @GetMapping(value={"/all/resource/count"})
    public List<ResourceBean> getAllResourceCount();

    @PostMapping(value={"/get/name"})
    public List<Map> getNameById(@RequestBody String[] var1);

    @GetMapping(value={"/judge/repeat/theme/{themeName}"})
    public int judgeRepeatTheme(@PathVariable(name="themeName") String var1);

    @GetMapping(value={"/resource/all"})
    public LayPage<ResourceDto> findResourceListForPage(@RequestBody LayPageable var1, @RequestParam(name="username") String var2, @RequestParam(name="instanceType") String var3, @RequestParam(name="typeId") String var4);

    @GetMapping(value={"/apply/resource"})
    public LayPage<ResourceApplyDto> findApplyForPage(@RequestBody LayPageable var1, @RequestParam(name="username") String var2, @RequestParam(name="instanceType") String var3, @RequestParam(name="typeId") String var4);

    @DeleteMapping(value={"/res/delete/{id}"})
    public void deleteResByThemeId(@PathVariable(name="id") String var1);

    @PutMapping(value={"/update/supermap/rest/{id}"})
    public ResourceDto updateSupermapRestById(@PathVariable(name="id") String var1, @RequestBody ResourceDto var2);

    @GetMapping(value={"/all/resource"})
    public LayPage<ResourceDto> findAllResource(@RequestBody LayPageable var1, @RequestParam(name="instanceType") String var2, @RequestParam(name="typeId") String var3);

    @GetMapping(value={"/visit/download/count"})
    public List<ResourceAccessBean> getAllVisitAndDownloadCount();

    @GetMapping(value={"/type/visit/download/count"})
    public List<ResourceAccessBean> getAllVisitAndDownCountByResourceType(@RequestParam(name="resourceType") String var1);

    @GetMapping(value={"/down/visit/{username}"})
    public List<ResourceAccessBean> getVisitAndDownloadCountByUserName(@PathVariable(name="username") String var1);

    @GetMapping(value={"/type/down/visit"})
    public List<ResourceAccessBean> getVisitAndDownloadCountByUserNameAndType(@RequestParam(name="username") String var1, @RequestParam(name="resourceType") String var2);

    @GetMapping(value={"/access/count/date/resourceType"})
    public List<ResourceAccessBean> getResourceAccessCountByTypeAndDate(@RequestParam(name="type") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/access/count/date"})
    public List<ResourceAccessBean> getAllAccessCountByDate(@RequestParam(name="startDate") Date var1, @RequestParam(name="endDate") Date var2);

    @GetMapping(value={"/access/count/date/modelId"})
    public List<ResourceAccessBean> getResourceAccessCountByModelAndDate(@RequestParam(name="model") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/date/access/count/resourceId"})
    public List<ResourceAccessBean> getResourceAccessCountByResourceIdAndDate(@RequestParam(name="resourceId") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/resource/id/name"})
    public List<ResourceBean> getResourceIdAndName();

    @GetMapping(value={"/type/resource/id/name/{type}"})
    public List<ResourceBean> getResourceIdAndNameByResourceType(@PathVariable(name="type") String var1);

    @GetMapping(value={"/model/resource/id/name/{modelId}"})
    public List<ResourceBean> getResourceIdAndNameByModelId(@PathVariable(name="modelId") String var1);

    @GetMapping(value={"/resources/page"})
    public LayPage<ResourceAccessDto> getResourcesPage(@RequestParam(name="username") String var1, @RequestParam(name="type") String var2, @RequestParam(name="model") String var3, @RequestParam(name="resourceId") String var4, @RequestBody LayPageable var5);

    @GetMapping(value={"/personal/resource/id/name/{username}"})
    public List<ResourceBean> getResourcesResourceIdAndNameByUserName(@PathVariable(name="username") String var1);

    @GetMapping(value={"/personal/type/resource/id/name"})
    public List<ResourceBean> getResourceResourceIdAndNameByUserNameAndResourceType(@RequestParam(name="username") String var1, @RequestParam(name="resourceType") String var2);

    @GetMapping(value={"/personal/model/resource/id/name"})
    public List<ResourceBean> getResourceResourceIdAndNameByUserNameAndModelId(@RequestParam(name="username") String var1, @RequestParam(name="modelId") String var2);

    @GetMapping(value={"/apply/resources"})
    public PageDataDto getApplyResourceListForPage(@RequestBody ResourceQueryDto var1);

    @GetMapping(value={"/all/resources/page"})
    public PageDataDto getAllResourceListForPage(@RequestBody ResourceQueryDto var1);

    @GetMapping(value={"/type/and/model/{resourceId}"})
    public List<ResourceBean> getResourceTypeAndModelIdByResourceId(@PathVariable(value="resourceId") String var1);

    @GetMapping(value={"/resource/access/apply/page"})
    public LayPage<ResourceAccessBean> getResourceAccessAndApplyPageByUserName(@RequestParam(name="username", required=false) String var1, @RequestBody LayPageable var2);

    @GetMapping(value={"/resource/access/apply/id/page"})
    public LayPage<ResourceAccessBean> getResourceAccessAndApplyPageByUserNameAndResourceId(@RequestParam(name="username", required=false) String var1, @RequestParam(name="resourceId", required=false) String var2, @RequestBody LayPageable var3);

    @GetMapping(value={"/resource/access/apply/model/page"})
    public LayPage<ResourceAccessBean> getResourceAccessAndApplyPageByUserNameAndResourceModelId(@RequestParam(name="username", required=false) String var1, @RequestParam(name="modelId", required=false) String var2, @RequestBody LayPageable var3);

    @GetMapping(value={"/resource/access/apply"})
    public LayPage<ResourceAccessBean> getResourceAccessAndApply(@RequestParam(name="username", required=false) String var1, @RequestParam(name="resourceId", required=false) String var2, @RequestParam(name="modelId", required=false) String var3, @RequestParam(name="resourceType", required=false) String var4, @RequestBody LayPageable var5);

    @GetMapping(value={"/new/examine/page"})
    public PageDataDto newExaminePage(@RequestBody ResourceQueryDto var1);
}

