/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.datagovern.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final String CHARACTER_ENCODING = "utf-8";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int MAX_ENCRYPT_BLOCK = 234;
    private static final int MAX_DECRYPT_BLOCK = 256;

    private RSAUtils() {
    }

    private static String encryptBASE64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    private static byte[] decryptBASE64(String data) {
        return Base64.getDecoder().decode(data);
    }

    public static KeyPair initKey() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(2048);
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicKey(KeyPair keyPair) {
        return RSAUtils.encryptBASE64(keyPair.getPublic().getEncoded());
    }

    public static String getPrivateKey(KeyPair keyPair) {
        return RSAUtils.encryptBASE64(keyPair.getPrivate().getEncoded());
    }

    public static String encryptByPublicKey(String data, String key) throws Exception {
        return RSAUtils.encryptBASE64(RSAUtils.encryptByPublicKey(data.getBytes(CHARACTER_ENCODING), key));
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) throws Exception {
        return RSAUtils.cryptoByPublicKey(1, data, RSAUtils.decryptBASE64(key));
    }

    public static String decryptByPublicKey(String data, String key) throws Exception {
        return new String(RSAUtils.decryptByPublicKey(RSAUtils.decryptBASE64(data), key), CHARACTER_ENCODING);
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) throws Exception {
        return RSAUtils.cryptoByPublicKey(2, data, RSAUtils.decryptBASE64(key));
    }

    private static byte[] cryptoByPublicKey(int opmode, byte[] data, byte[] keyBytes) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(opmode, publicKey);
        return RSAUtils.handleResult(opmode, data, cipher);
    }

    private static byte[] handleResult(int opmode, byte[] data, Cipher cipher) throws Exception {
        int maxHandleLength;
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        int n = maxHandleLength = opmode == 1 ? 234 : 256;
        while (inputLen > offset) {
            int length = inputLen - offset > maxHandleLength ? maxHandleLength : inputLen - offset;
            byte[] cache = cipher.doFinal(data, offset, length);
            out.write(cache, 0, cache.length);
            offset = ++i * maxHandleLength;
        }
        byte[] resultData = out.toByteArray();
        out.close();
        return resultData;
    }

    public static String encryptByPrivateKey(String data, String key) throws Exception {
        return RSAUtils.encryptBASE64(RSAUtils.encryptByPrivateKey(data.getBytes(CHARACTER_ENCODING), key));
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) throws Exception {
        return RSAUtils.cryptoByPrivateKey(1, data, RSAUtils.decryptBASE64(key));
    }

    public static String decryptByPrivateKey(String data, String key) throws Exception {
        return new String(RSAUtils.decryptByPrivateKey(RSAUtils.decryptBASE64(data), key), CHARACTER_ENCODING);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) throws Exception {
        return RSAUtils.cryptoByPrivateKey(2, data, RSAUtils.decryptBASE64(key));
    }

    private static byte[] cryptoByPrivateKey(int opmode, byte[] data, byte[] keyBytes) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(opmode, privateKey);
        return RSAUtils.handleResult(opmode, data, cipher);
    }

    public static String sign(String data, String privateKey) throws Exception {
        return RSAUtils.sign(data.getBytes(CHARACTER_ENCODING), privateKey);
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = RSAUtils.decryptBASE64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return RSAUtils.encryptBASE64(signature.sign());
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        return RSAUtils.verify(data.getBytes(CHARACTER_ENCODING), publicKey, sign);
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = RSAUtils.decryptBASE64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(RSAUtils.decryptBASE64(sign));
    }
}

