/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.datagovern.clients.publicity;

import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import cn.gtmap.ias.datagovern.domain.dto.DataMenu;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.data.name}")
@RequestMapping(value={"${app.feign-client.data.context-path}/rest/data"})
public interface GovernClient {
    @PostMapping(value={"/public/getTableInfos"})
    public List<DataMenu> getTableInfos(@RequestParam(name="dataMenus", required=false) String var1, @RequestParam(name="tables", required=false) String var2);

    @PostMapping(value={"/public/getFiled"})
    public List<Map> getFiled(@RequestParam(name="dataSetId", required=false) Integer var1);

    @GetMapping(value={"/public/tableItems"})
    public List<Map> getTableItems(LayPageable var1, @RequestParam(name="tableName", required=true) String var2);

    @GetMapping(value={"/public/tableItemsByField"})
    public List<Map> tableItemsByField(@RequestBody Map<String, String> var1);

    @GetMapping(value={"/public/queryTableItemCount"})
    public Long queryTableItemCount(@RequestParam(name="tableName", required=true) String var1);

    @GetMapping(value={"/public/queryTableItemCountByField"})
    public Long queryTableItemCountByField(@RequestBody Map<String, String> var1);

    @GetMapping(value={"/public/smregister/data"})
    public List<Map> getSmRegisterData();

    @GetMapping(value={"/public/pgclass/data"})
    public List<Map> getPgClassData();

    @PostMapping(value={"/point"})
    public boolean savePoint(@RequestBody Map<String, String> var1);

    @GetMapping(value={"/transformGeometry"})
    public String transformGeometry(@RequestParam(name="geometry", required=false) String var1);

    @GetMapping(value={"/public/person/callout/page"})
    public LayPage<Map> findCallout(LayPageable var1);

    @GetMapping(value={"/public/table/{theme}"})
    public List<Map> findTableByTheme(@PathVariable(value="theme") String var1);
}

