/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.datagovern.clients;

import cn.gtmap.ias.basic.domain.dto.AjaxResult;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.datagovern.domain.dto.DictionaryDetailDto;
import cn.gtmap.ias.datagovern.domain.dto.DictionaryDto;
import cn.gtmap.ias.datagovern.domain.dto.ResultJsonDto;
import cn.gtmap.ias.datagovern.domain.dto.page.LayPageable;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.data.name}")
@RequestMapping(value={"${app.feign-client.data.context-path}/resource/dictionary"})
public interface MapDictionaryClient {
    @GetMapping(value={"/code"})
    public ResultJsonDto getRegionName(@RequestParam String var1);

    @PostMapping(value={"/convert"})
    public ResultJsonDto ResultConvert(@RequestBody List<Map> var1, @RequestParam String var2);

    @GetMapping(value={"/{id}"})
    public DictionaryDto findById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/page"})
    public LayPage<DictionaryDto> page(@RequestBody LayPageable var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="type", required=false) String var3);

    @PostMapping
    public AjaxResult save(@RequestBody DictionaryDto var1);

    @PostMapping(value={"/init"})
    public AjaxResult init(@RequestBody List<DictionaryDto> var1);

    @PutMapping(value={"/{id}"})
    public AjaxResult update(@PathVariable(name="id") String var1, @RequestBody DictionaryDto var2);

    @PatchMapping(value={"/{id}/enabled"})
    public void enable(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/disabled"})
    public void disable(@PathVariable(name="id") String var1);

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(name="id") String var1);

    @DeleteMapping
    public void delete(@RequestBody List<String> var1);

    @GetMapping
    public List<DictionaryDto> findAll(@RequestParam(name="name", required=false) String var1);

    @GetMapping(value={"/details"})
    public LayPage<DictionaryDetailDto> pageDetails(@RequestBody LayPageable var1, @RequestParam(name="type") String var2, @RequestParam(name="label", required=false) String var3);

    @GetMapping(value={"/details/{type}"})
    public List<DictionaryDetailDto> findDetailsByType(@PathVariable(name="type") String var1);

    @PostMapping(value={"/detail"})
    public AjaxResult saveDetail(@RequestBody DictionaryDetailDto var1);

    @PutMapping(value={"/detail/{id}"})
    public AjaxResult updateDetail(@PathVariable(name="id") String var1, @RequestBody DictionaryDetailDto var2);

    @GetMapping(value={"/detail/{id}"})
    public DictionaryDetailDto findDetailById(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/detail/{id}/enabled"})
    public void enableDetail(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/detail/{id}/disabled"})
    public void disableDetail(@PathVariable(name="id") String var1);

    @DeleteMapping(value={"/detail/{id}"})
    public void deleteDetail(@PathVariable(name="id") String var1);

    @GetMapping(value={"/detail"})
    public DictionaryDetailDto findDetailByTypeAndValue(@RequestParam(name="type") String var1, @RequestParam(name="value") String var2);

    @GetMapping(value={"/table"})
    public List<DictionaryDto> findByRemark(@RequestParam(name="remark") String var1);
}

