/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.datagovern.clients;

import cn.gtmap.ias.datagovern.domain.dto.FloodQueryDto;
import cn.gtmap.ias.datagovern.domain.dto.ResultJsonDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.data.name}")
@RequestMapping(value={"${app.feign-client.data.context-path}/rest/flood"})
public interface FloodPreventionClient {
    @GetMapping(value={"/menu"})
    public String getMenuData();

    @PostMapping(value={"/warning/record"})
    public ResultJsonDto getWarningData(@RequestBody FloodQueryDto var1);

    @GetMapping(value={"/fieldData"})
    public ResultJsonDto getFieldNameByTableName(@RequestParam(name="tableName") String var1);

    @GetMapping(value={"all"})
    public ResultJsonDto getAllByTableName(@RequestParam(name="tableName") String var1);

    @PostMapping(value={"allByPage"})
    public ResultJsonDto getAllByTableNameByPage(@RequestParam(name="page") int var1, @RequestParam(name="pageSize") int var2, @RequestParam(name="tableName") String var3, @RequestParam(name="fieldName", required=false) String var4, @RequestParam(name="queryData", required=false) String var5);

    @PostMapping(value={"/precipitation/new"})
    public ResultJsonDto getNewPrecipitationData(@RequestBody FloodQueryDto var1);

    @PostMapping(value={"/river/new"})
    public ResultJsonDto getNewRiverData(@RequestBody FloodQueryDto var1);

    @PostMapping(value={"/rsvr/new"})
    public ResultJsonDto getNewRsvrData(@RequestBody FloodQueryDto var1);

    @PostMapping(value={"/period/accumulation"})
    public ResultJsonDto getPeriodAccumulationData(@RequestBody FloodQueryDto var1);

    @PostMapping(value={"/pptn/statistics"})
    public ResultJsonDto getPptnStatisticsData(@RequestBody FloodQueryDto var1);

    @PostMapping(value={"/log"})
    public ResultJsonDto getFxLogs(@RequestBody FloodQueryDto var1);
}

