/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.clients;

import cn.gtmap.ias.basic.domain.dto.MenuDto;
import cn.gtmap.ias.basic.domain.dto.UserDto;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.basic.name}")
@RequestMapping(value={"${app.feign-client.basic.context-path}/resource/user"})
public interface UserClient {
    @GetMapping(value={"/{id}"})
    public UserDto findById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/username/{username}"})
    public UserDto findByUsername(@PathVariable(name="username") String var1);

    @GetMapping
    public List<UserDto> query(@RequestParam(name="username", required=false) String var1, @RequestParam(name="alias", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3);

    @GetMapping(value={"/page"})
    public LayPage<UserDto> page(@RequestBody LayPageable var1, @RequestParam(name="username", required=false) String var2, @RequestParam(name="alias", required=false) String var3);

    @PostMapping
    public UserDto save(@RequestBody UserDto var1);

    @PutMapping(value={"/{id}"})
    public UserDto update(@PathVariable(name="id") String var1, @RequestBody UserDto var2);

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(name="id") String var1);

    @DeleteMapping
    public void delete(@RequestBody List<String> var1);

    @PatchMapping(value={"/{id}/enabled"})
    public void enable(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/disabled"})
    public void disable(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{username}/password/validation"})
    public boolean validatePassword(@PathVariable(name="username") String var1, @RequestParam(name="password") String var2);

    @PostMapping(value={"/{username}/password"})
    public void modifyPassword(@PathVariable(name="username") String var1, @RequestBody UserDto var2);

    @GetMapping(value={"/menus"})
    public List<MenuDto> getMenus();

    @GetMapping(value={"/enabled/count"})
    public long countEnabled();

    @GetMapping(value={"/online/count"})
    public long getOnlineUsersCount();

    @PutMapping(value={"/roles/{id}"})
    public UserDto updateUserRoles(@PathVariable(name="id") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/findUserByOrgId"})
    public List<UserDto> findUserByOrgId(@RequestParam(name="orgId", required=false) String var1);

    @PostMapping(value={"/all/page"})
    public LayPage<UserDto> getAllUserListForPage(@RequestBody UserDto var1);
}

