/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.clients;

import cn.gtmap.ias.basic.domain.dto.StorageDto;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="${app.feign-client.basic.name}")
@RequestMapping(value={"${app.feign-client.basic.context-path}/resource/storage"})
public interface StorageClient {
    @DeleteMapping
    public void delete(@RequestBody List<String> var1);

    @DeleteMapping(value={"/businessId/{businessId}"})
    public void deleteByBusinessId(@PathVariable(name="businessId") String var1);

    @GetMapping
    public LayPage<StorageDto> page(LayPageable var1, @RequestParam(name="businessId", required=false) String var2, @RequestParam(name="parentId", required=false) String var3);

    @GetMapping(value={"/{id}/node-path"})
    public List<StorageDto> getNodePath(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}"})
    public StorageDto findById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/existence"})
    public boolean checkExist(@RequestParam(name="parentId") String var1, @RequestParam(name="name") String var2);

    @PostMapping(value={"/folder"})
    public void createFolder(@RequestParam(name="parentId", required=false) String var1, @RequestParam(name="name") String var2);

    @PostMapping(value={"/parent/init"})
    public StorageDto initParent(@RequestParam(name="businessId") String var1);

    @GetMapping(value={"/pageByType"})
    public LayPage<StorageDto> pageByFileType(LayPageable var1, @RequestParam(name="fileType", required=false) String var2);

    @PostMapping(value={"/upload/multi"}, consumes={"multipart/form-data"})
    public boolean uploadFile(@RequestPart(value="file") MultipartFile[] var1, @RequestParam(name="parentId", required=false) String var2, @RequestParam(name="businessId", required=false) String var3);

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public StorageDto uploadFile(HttpServletRequest var1, @RequestPart(value="file") MultipartFile var2, @RequestParam(name="parentId", required=false) String var3, @RequestParam(name="businessId", required=false) String var4);

    @PostMapping(value={"/upload/limit"}, consumes={"multipart/form-data"})
    public StorageDto uploadLimitFile(HttpServletRequest var1, @RequestPart(value="file") MultipartFile var2, @RequestParam(name="parentId", required=false) String var3, @RequestParam(name="businessId", required=false) String var4);

    @GetMapping(value={"/image/base64/{id}"})
    public String showImageBase64(@PathVariable(name="id") String var1);

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<Resource> show(@PathVariable(name="id") String var1);

    @GetMapping(value={"/download/{id}"})
    public ResponseEntity<Resource> download(@PathVariable(name="id") String var1);

    @GetMapping(value={"/pdf/{id}"})
    public ResponseEntity<Resource> convert2Pdf(@PathVariable(name="id") String var1);

    @GetMapping(value={"/zip/download"})
    public ResponseEntity<Resource> zipDownload(@RequestParam(name="id") List<String> var1);
}

