/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.clients;

import cn.gtmap.ias.basic.domain.dto.RoleDto;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.basic.name}")
@RequestMapping(value={"${app.feign-client.basic.context-path}/resource/role"})
public interface RoleClient {
    @GetMapping(value={"/code/random"})
    public String getRandomCode();

    @GetMapping(value={"/{id}"})
    public RoleDto findById(@PathVariable(name="id") String var1);

    @GetMapping
    public List<RoleDto> query(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3);

    @GetMapping(value={"/page"})
    public LayPage<RoleDto> page(@RequestBody LayPageable var1, @RequestParam(name="code", required=false) String var2, @RequestParam(name="name", required=false) String var3);

    @PostMapping
    public RoleDto save(@RequestBody RoleDto var1);

    @PutMapping(value={"/{id}"})
    public RoleDto update(@PathVariable(name="id") String var1, @RequestBody RoleDto var2);

    @DeleteMapping(value={"/{id}"})
    public boolean delete(@PathVariable(name="id") String var1);

    @DeleteMapping
    public boolean delete(@RequestBody List<String> var1);

    @PatchMapping(value={"/{id}/enabled"})
    public void enable(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/disabled"})
    public void disable(@PathVariable(name="id") String var1);

    @GetMapping(value={"/enabled/all"})
    public List<RoleDto> findAllEnabled();

    @GetMapping(value={"/code/{code}"})
    public RoleDto findByCode(@PathVariable(name="code") String var1);

    @PostMapping(value={"/findAll"})
    public List<RoleDto> findAll(@RequestBody RoleDto var1);

    @GetMapping(value={"/initAdmin"})
    public void initAdmin();
}

