/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.clients;

import cn.gtmap.ias.basic.domain.dto.OrgDto;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.basic.name}")
@RequestMapping(value={"${app.feign-client.basic.context-path}/resource/org"})
public interface OrgClient {
    @GetMapping
    public OrgDto findById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/page"})
    public LayPage<OrgDto> page(@RequestBody LayPageable var1, @RequestParam(name="code", required=false) String var2, @RequestParam(name="name", required=false) String var3);

    @PostMapping
    public OrgDto save(@RequestBody OrgDto var1);

    @PutMapping(value={"/{id}"})
    public OrgDto update(@PathVariable(name="id") String var1, @RequestBody OrgDto var2);

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(name="id") String var1);

    @DeleteMapping
    public void delete(@RequestBody List<String> var1);

    @PatchMapping(value={"/{id}/enabled"})
    public void enable(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/disabled"})
    public void disable(@PathVariable(name="id") String var1);

    @GetMapping(value={"/top"})
    public List<OrgDto> findFirstOrgInfo();

    @GetMapping(value={"/findByName"})
    public OrgDto findByName(@RequestParam(name="orgName") String var1);

    @GetMapping(value={"/all"})
    public List<OrgDto> findAllOrgDtos();

    @PostMapping(value={"/recursionFind"})
    public List<OrgDto> recursionFind(@RequestBody OrgDto var1);
}

