/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.clients;

import cn.gtmap.ias.basic.domain.dto.MenuDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.basic.name}")
@RequestMapping(value={"${app.feign-client.basic.context-path}/resource/menu"})
public interface MenuClient {
    @GetMapping(value={"/menu"})
    public List<MenuDto> getMenu(@RequestParam(name="menuId", required=false) String var1);

    @PostMapping
    public MenuDto save(@RequestBody MenuDto var1);

    @PostMapping(value={"/saveOne"})
    public MenuDto saveOne(@RequestBody MenuDto var1);

    @PutMapping(value={"/{id}"})
    public MenuDto update(@PathVariable(name="id") String var1, @RequestBody MenuDto var2);

    @GetMapping
    public List<MenuDto> findAll(@RequestParam(name="enabled", required=false) Integer var1);

    @GetMapping(value={"/find"})
    public List<MenuDto> find(@RequestBody MenuDto var1);

    @GetMapping(value={"/findContainParent"})
    public List<MenuDto> findContainParent(@RequestBody MenuDto var1);

    @GetMapping(value={"/recursionFind"})
    public List<MenuDto> recursionFind(@RequestBody MenuDto var1);

    @GetMapping(value={"/{id}"})
    public MenuDto findById(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/enabled"})
    public void enable(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/{id}/disabled"})
    public void disable(@PathVariable(name="id") String var1);

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String var1);

    @GetMapping(value={"/tops"})
    public List<MenuDto> findTopMenus();

    @GetMapping(value={"/{id}/order"})
    public MenuDto changeOrder(@PathVariable(name="id") String var1, @RequestParam(name="moveType") String var2, @RequestParam(name="targetNode") String var3);

    @PatchMapping(value={"/{id}/inner"})
    public void inner(@PathVariable(name="id") String var1, @RequestParam(name="status") Integer var2);

    @GetMapping(value={"/topsRelated"})
    public List<MenuDto> findTopMenusRelated();

    @GetMapping(value={"/findByUsernameOrTitle"})
    public List<MenuDto> findByUsernameOrTitle(@RequestParam(name="username", required=false) String var1, @RequestParam(name="title", required=false) String var2);

    @PostMapping(value={"/init"})
    public List<MenuDto> init(@RequestBody List<MenuDto> var1);

    @GetMapping(value={"/findCodeByUsername"})
    public String findCodeByUsername(@RequestParam(name="username", required=false) String var1);
}

