/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtmapFeignException
extends FeignException {
    private static final Logger log = LoggerFactory.getLogger(GtmapFeignException.class);
    private Throwable cause;
    private static ObjectMapper mapper = new ObjectMapper();

    public GtmapFeignException(int status, String message) {
        super(status, message);
    }

    public GtmapFeignException(int status, String message, Throwable cause) {
        super(status, message);
        this.cause = cause;
    }

    public static FeignException errorStatus(String methodKey, Response response) {
        String message = "";
        try {
            if (response.body() != null) {
                String body = Util.toString((Reader)response.body().asReader());
                log.info("response body >>>> " + body);
                Map map = (Map)mapper.readValue(body, Map.class);
                message = (String)map.get("message");
            } else {
                message = String.format("status %s reading %s", response.status(), methodKey);
            }
            log.info("response status >>>> " + response.status());
            log.info("message >>>> " + message);
        }
        catch (IOException e) {
            log.error("read response body error", (Throwable)e);
        }
        GtmapFeignException exception = new GtmapFeignException(response.status(), message);
        if (exception.getCause() != null) {
            log.error(exception.getCause().getLocalizedMessage(), exception.getCause());
        } else {
            log.error(exception.getLocalizedMessage(), (Throwable)((Object)exception));
        }
        return exception;
    }
}

