/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.exception;

import cn.gtmap.ias.basic.client.starter.exception.GtmapFeignException;
import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GtmapErrorEncoder
implements ErrorDecoder {
    private final RetryAfterDecoder retryAfterDecoder = new RetryAfterDecoder();

    public Exception decode(String methodKey, Response response) {
        FeignException exception = GtmapFeignException.errorStatus(methodKey, response);
        Date retryAfter = this.retryAfterDecoder.apply((String)this.firstOrNull(response.headers(), "Retry-After"));
        return retryAfter != null ? new RetryableException(response.status(), exception.getMessage(), response.request().httpMethod(), retryAfter, response.request()) : exception;
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        return map.containsKey(key) && !map.get(key).isEmpty() ? (T)map.get(key).iterator().next() : null;
    }

    public static class RetryAfterDecoder {
        static final DateFormat RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final DateFormat rfc822Format;

        RetryAfterDecoder() {
            this(RFC822_FORMAT);
        }

        RetryAfterDecoder(DateFormat rfc822Format) {
            this.rfc822Format = (DateFormat)Util.checkNotNull((Object)rfc822Format, (String)"rfc822Format", (Object[])new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+$")) {
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return new Date(this.currentTimeMillis() + deltaMillis);
            }
            DateFormat var2 = this.rfc822Format;
            DateFormat dateFormat = this.rfc822Format;
            synchronized (dateFormat) {
                Date var10000;
                try {
                    var10000 = this.rfc822Format.parse(retryAfter);
                }
                catch (ParseException var5) {
                    return null;
                }
                return var10000;
            }
        }
    }
}

