/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.config;

import cn.gtmap.ias.basic.client.starter.config.CustomAccessDecisionManager;
import cn.gtmap.ias.basic.client.starter.config.CustomFilterInvocationSecurityMetadataSource;
import cn.gtmap.ias.basic.client.starter.config.CustomFilterSecurityInterceptor;
import cn.gtmap.ias.basic.client.starter.config.GtmapSessionInformationExpiredStrategy;
import cn.gtmap.ias.basic.client.starter.config.GtmapSessionRegistryImpl;
import cn.gtmap.ias.basic.client.starter.config.SsoSecurityConfigurer;
import cn.gtmap.ias.basic.client.starter.property.AppSecurity;
import cn.gtmap.ias.basic.client.starter.util.Authority;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.util.StringUtils;

@Configuration
public class SsoWebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final Logger logger = LoggerFactory.getLogger(SsoWebSecurityConfiguration.class);
    private final ApplicationContext applicationContext;
    private final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private final AppSecurity appSecurity;

    public CustomFilterSecurityInterceptor createFilterSecurityInterceptor() {
        CustomAccessDecisionManager accessDecisionManager = new CustomAccessDecisionManager();
        CustomFilterInvocationSecurityMetadataSource securityMetadataSource = new CustomFilterInvocationSecurityMetadataSource(this.appSecurity);
        CustomFilterSecurityInterceptor interceptor = new CustomFilterSecurityInterceptor();
        interceptor.setAccessDecisionManager(accessDecisionManager);
        interceptor.setSecurityMetadataSource(securityMetadataSource);
        return interceptor;
    }

    public SsoWebSecurityConfiguration(ApplicationContext applicationContext, AppSecurity appSecurity) {
        this.applicationContext = applicationContext;
        this.appSecurity = appSecurity;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.addFilterBefore((Filter)this.createFilterSecurityInterceptor(), FilterSecurityInterceptor.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/login"})).permitAll();
        for (Map.Entry<String, String[]> entry : this.appSecurity.getAuthorities().entrySet()) {
            try {
                if (!"permitAll".equalsIgnoreCase(entry.getKey())) continue;
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(entry.getValue())).permitAll().and();
            }
            catch (Exception e) {
                this.logger.error("app.security.authorities has wrong key or values [{}]", (Object)e.getLocalizedMessage());
            }
        }
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).formLogin().and()).rememberMe().and()).csrf().disable();
        RequestHeaderRequestMatcher preferredMatcher = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
        http.exceptionHandling().accessDeniedPage("/accessDenied");
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).maximumSessions(-1).expiredSessionStrategy((SessionInformationExpiredStrategy)new GtmapSessionInformationExpiredStrategy()).sessionRegistry(this.sessionRegistry());
        http.cors();
        ((HttpSecurity)http.csrf().disable()).headers().contentTypeOptions().disable().frameOptions().disable().cacheControl().disable();
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
    }

    private String processKey(String key) {
        if (key.indexOf("hasRole") >= 0) {
            return key.replace("hasRole", "hasRole('").concat("')");
        }
        return key;
    }

    public void configure(WebSecurity web) throws Exception {
        if (this.appSecurity.getIgnores() == null || this.appSecurity.getIgnores().length == 0) {
            super.configure(web);
        }
        try {
            web.ignoring().antMatchers(this.appSecurity.getIgnores());
        }
        catch (Exception e) {
            this.logger.error("app.security.ignores has wrong values [{}]", (Object)e.getLocalizedMessage());
        }
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new GtmapSessionRegistryImpl();
    }

    private void loadAuthorityJson(HttpSecurity http) throws Exception {
        List<Authority> authorities = null;
        try {
            authorities = this.getAuthFromInterface();
        }
        catch (IOException e) {
            this.logger.error("request authority exception", (Throwable)e);
        }
        if (authorities == null || authorities.size() == 0) {
            return;
        }
        this.processAuthorities(http, authorities);
    }

    public List<Authority> getAuthFromInterface() throws IOException {
        String authUrl = this.appSecurity.getAuthUrl();
        if (StringUtils.isEmpty((Object)authUrl)) {
            return null;
        }
        HttpClient client = new HttpClient();
        GetMethod getMethod = new GetMethod(authUrl);
        getMethod.getParams().setContentCharset("UTF-8");
        client.executeMethod((HttpMethod)getMethod);
        String responseBody = getMethod.getResponseBodyAsString();
        return JSON.parseArray((String)responseBody, Authority.class);
    }

    private void processAuthorities(HttpSecurity http, List<Authority> authorities) throws Exception {
        HashMap map = new HashMap();
        for (Authority authority : authorities) {
            String[] urls;
            String role = authority.getRole();
            String temp = authority.getUrl();
            for (String url : urls = temp.split(",")) {
                url = url.trim();
                List<String> value = null;
                if (map.containsKey(url)) {
                    value = (List)map.get(url);
                } else {
                    value = new ArrayList();
                    map.put(url, value);
                }
                value.add(role);
            }
        }
        for (String url : map.keySet()) {
            List value = (List)map.get(url);
            String[] roles = value.toArray(new String[value.size()]);
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{url})).hasAnyRole(roles).and();
        }
    }
}

