/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.config;

import cn.gtmap.ias.basic.client.starter.exception.NoResouceFoundException;
import cn.gtmap.ias.basic.client.starter.property.AppSecurity;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    private final Logger logger = LoggerFactory.getLogger(ResourceServerConfiguration.class);
    private final AppSecurity appSecurity;

    public ResourceServerConfiguration(AppSecurity appSecurity) {
        this.appSecurity = appSecurity;
    }

    public void configure(HttpSecurity http) {
        if (this.appSecurity.getResources() == null || CollectionUtils.isEmpty(this.appSecurity.getResources().entrySet())) {
            throw new NoResouceFoundException("app.security.resource is required");
        }
        for (Map.Entry<String, String[]> entry : this.appSecurity.getResources().entrySet()) {
            try {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(entry.getValue())).and().authorizeRequests().anyRequest()).access("#oauth2".concat(".").concat(this.processKey(entry.getKey())));
            }
            catch (Exception e) {
                this.logger.error("app.security.resources has wrong key or values [{}]", (Object)e.getLocalizedMessage());
            }
        }
    }

    private String processKey(String key) {
        if (key.indexOf("hasScope") < 0) {
            return key;
        }
        return key.replace("hasScope", "hasScope('").concat("')");
    }
}

