/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.config;

import cn.gtmap.ias.basic.client.starter.config.CustomFilterInvocationSecurityMetadataSource;
import cn.gtmap.ias.basic.client.starter.property.AppSecurity;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.server.PathContainer;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.web.util.pattern.PathPatternParser;

public class CustomFilterSecurityInterceptor
extends AbstractSecurityInterceptor
implements Filter {
    private FilterInvocationSecurityMetadataSource securityMetadataSource;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        this.invoke(fi, this.shouldFilter(request));
    }

    private boolean shouldFilter(ServletRequest request) {
        String[] authIgnores;
        CustomFilterInvocationSecurityMetadataSource metadataSource = (CustomFilterInvocationSecurityMetadataSource)this.securityMetadataSource;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        String path = requestURI.replaceFirst(contextPath, "");
        AppSecurity appSecurity = metadataSource.getAppSecurity();
        for (String ignoredUrl : authIgnores = appSecurity.getAuthIgnores()) {
            if (!CustomFilterSecurityInterceptor.matchUrl(ignoredUrl, path)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchUrl(String rule, String url) {
        return new PathPatternParser().parse(rule).matches(PathContainer.parsePath((String)url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(FilterInvocation fi, boolean shouldFilter) throws IOException, ServletException {
        if (!shouldFilter) {
            fi.getChain().doFilter((ServletRequest)fi.getRequest(), (ServletResponse)fi.getResponse());
            return;
        }
        InterceptorStatusToken token = super.beforeInvocation((Object)fi);
        try {
            fi.getChain().doFilter((ServletRequest)fi.getRequest(), (ServletResponse)fi.getResponse());
        }
        finally {
            super.afterInvocation(token, null);
        }
    }

    public void destroy() {
    }

    public Class<?> getSecureObjectClass() {
        return FilterInvocation.class;
    }

    public FilterInvocationSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }
}

