/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.config;

import cn.gtmap.ias.basic.client.starter.property.AppSecurity;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.StringUtils;

public class CustomFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private AppSecurity appSecurity;

    public CustomFilterInvocationSecurityMetadataSource(AppSecurity appSecurity) {
        this.appSecurity = appSecurity;
    }

    public AppSecurity getAppSecurity() {
        return this.appSecurity;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String path = request.getScheme().concat("://").concat(request.getServerName()).concat(":").concat(String.valueOf(request.getServerPort())).concat(requestURI);
        return this.loadAuthorities(path);
    }

    private Collection<ConfigAttribute> loadAuthorities(String url) {
        List<String> roles = null;
        try {
            roles = this.getAuthFromInterface(url);
        }
        catch (IOException e) {
            this.logger.error((Object)"request authorities from sso Exception", (Throwable)e);
        }
        if (roles == null || roles.size() == 0) {
            return null;
        }
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        for (String role : roles) {
            role = role.trim();
            SecurityConfig cfg = new SecurityConfig(role);
            configAttributes.add((ConfigAttribute)cfg);
        }
        return configAttributes;
    }

    public List<String> getAuthFromInterface(String url) throws IOException {
        String authUrl = this.appSecurity.getAuthUrl().concat("?url=").concat(url);
        if (StringUtils.isEmpty((Object)authUrl)) {
            return null;
        }
        HttpClient client = new HttpClient();
        GetMethod getMethod = new GetMethod(authUrl);
        getMethod.getParams().setContentCharset("UTF-8");
        client.executeMethod((HttpMethod)getMethod);
        String responseBody = getMethod.getResponseBodyAsString();
        return JSON.parseArray((String)responseBody, String.class);
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

