/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.config;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class CustomAccessDecisionManager
implements AccessDecisionManager {
    private final Log logger = LogFactory.getLog(this.getClass());

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException {
        if (null == configAttributes || configAttributes.size() == 0) {
            return;
        }
        for (ConfigAttribute c : configAttributes) {
            String needRole = "ROLE_" + c.getAttribute();
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!needRole.trim().equals(authority.getAuthority())) continue;
                return;
            }
        }
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String url = request.getRequestURI();
        this.logger.error((Object)("Request url:" + url + ", Access is denied"));
        throw new AccessDeniedException("Access is denied");
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

