/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.common;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.util.StringUtils;

public class LogoutUrlHandler {
    private static final Logger log = LoggerFactory.getLogger(LogoutUrlHandler.class);
    @Value(value="${app.web-basic-service}")
    private String oauth;
    @Value(value="${system.thirdParty.loginUrl:/login}")
    private String thirdParty_loginUrl;
    @Value(value="${security.login-success-url}")
    private String loginSuccessUrl;
    @Value(value="${security.logout-success-url}")
    private String logoutSuccessUrl;
    @Value(value="${system.thirdParty.logoutUrl:}")
    private String logoutUrl;

    public String processLogoutUrl(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            new SecurityContextLogoutHandler().logout(request, response, authentication);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        if (!"".equals(this.logoutUrl.trim())) {
            log.info("redirect to {}", (Object)this.getAccountLogoutPath().concat("?redirect_uri=" + this.getThirdLogoutPath()));
            return "redirect:".concat(this.getAccountLogoutPath().concat("?redirect_uri=" + this.getThirdLogoutPath()));
        }
        LocalDateTime now = LocalDateTime.now();
        long timestamp = now.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        System.out.println(this.getAccountLogoutPath().concat("?redirect_uri=" + this.getRequestPath(request).concat(this.loginSuccessUrl).concat("?t=").concat(String.valueOf(timestamp))));
        if (StringUtils.isEmpty((Object)this.logoutSuccessUrl)) {
            return "redirect:".concat(this.getAccountLogoutPath().concat("?redirect_uri=" + this.getRequestPath(request).concat(this.loginSuccessUrl).concat("?t=").concat(String.valueOf(timestamp))));
        }
        return "redirect:".concat(this.getAccountLogoutPath().concat("?redirect_uri=" + this.getRequestPath(request).concat(this.logoutSuccessUrl).concat("?t=").concat(String.valueOf(timestamp))));
    }

    private String getAccountLogoutPath() {
        return this.oauth.concat("/logout");
    }

    private String getRequestPath(HttpServletRequest request) {
        return request.getScheme().concat("://").concat(request.getServerName()).concat(":").concat(String.valueOf(request.getServerPort())).concat(request.getContextPath());
    }

    private String getThirdLogoutPath() {
        return this.logoutUrl + "?returnUrl=" + this.thirdParty_loginUrl;
    }
}

