/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.common;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class BaseController {
    private String username;
    private String loginRedirect;
    @Value(value="${app.basic-service}")
    private String basicService;
    @Value(value="${security.oauth2.client.client-id}")
    private String clientId;

    @ModelAttribute
    public void setWebAttribute(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        this.setUsername(authentication == null ? null : authentication.getName());
        request.setAttribute("contextPath", (Object)request.getContextPath());
        request.setAttribute("username", (Object)this.getUsername());
        this.setLoginRedirect(this.basicService.concat("/oauth/authorize?response_type=code&client_id=").concat(this.clientId).concat("&redirect_uri="));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLoginRedirect() {
        return this.loginRedirect;
    }

    public void setLoginRedirect(String loginRedirect) {
        this.loginRedirect = loginRedirect;
    }

    public String getBasicService() {
        return this.basicService;
    }

    public String getRequestPath(HttpServletRequest request) {
        return request.getScheme().concat("://").concat(request.getServerName()).concat(":").concat(String.valueOf(request.getServerPort())).concat(request.getContextPath());
    }

    public String getRequestUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public String getClientIP(HttpServletRequest request) {
        return request.getRemoteAddr();
    }
}

