/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.basic.client.starter.aspect;

import cn.gtmap.ias.basic.client.starter.annotation.ApiLog;
import cn.gtmap.ias.basic.client.starter.annotation.LogObject;
import cn.gtmap.ias.basic.clients.LogClient;
import cn.gtmap.ias.basic.domain.dto.LogDto;
import cn.gtmap.ias.basic.utils.RequestUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private LogClient logClient;

    @Pointcut(value="@annotation(cn.gtmap.ias.basic.client.starter.annotation.ApiLog)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    @AfterReturning(returning="ret", pointcut="pointCut()")
    public void doAfterReturning(JoinPoint joinPoint, Object ret) {
        this.addLog(joinPoint, true);
    }

    @AfterThrowing(pointcut="pointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        this.addLog(joinPoint, false);
    }

    @Before(value="pointCut()")
    public void doBeforeAdvice(JoinPoint joinPoint) {
    }

    @After(value="pointCut()")
    public void after(JoinPoint joinPoint) {
    }

    private void addLog(JoinPoint joinPoint, boolean successful) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiLog apiLog = method.getAnnotation(ApiLog.class);
        String event = apiLog.event();
        String object = apiLog.object();
        String target = this.parseTarget(signature, joinPoint, apiLog.target());
        if (object.equals("None")) {
            object = this.getLogObject(method.getDeclaringClass());
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        LogDto logDto = new LogDto();
        logDto.setEvent(event);
        logDto.setIp(RequestUtil.getIPAddress((HttpServletRequest)request));
        logDto.setRequestUrl(request.getRequestURL().toString());
        logDto.setTarget(target);
        logDto.setModule(request.getContextPath().substring(1));
        logDto.setUsername(this.getCurrentUsername(joinPoint));
        logDto.setDescription(event.concat(object).concat(successful ? "\u6210\u529f" : "\u5931\u8d25"));
        this.logClient.save(logDto);
        if (successful) {
            log.info(logDto.getDescription());
        } else {
            log.error(logDto.getDescription());
        }
    }

    private String getLogObject(Class clazz) {
        LogObject annotation = clazz.getAnnotation(LogObject.class);
        if (annotation == null) {
            return "";
        }
        try {
            Method logObjMethod = annotation.getClass().getDeclaredMethod("value", null);
            return (String)logObjMethod.invoke((Object)annotation, null);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65e5\u5fd7\u5bf9\u8c61\u5f02\u5e38\uff0c\u67e5\u770b\u662f\u5426\u914d\u7f6e@LogObject\u6ce8\u89e3", (Throwable)e);
            return "";
        }
    }

    private String getCurrentUsername(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof Authentication)) continue;
            Authentication authentication = (Authentication)arg;
            return authentication == null ? null : authentication.getName();
        }
        return null;
    }

    private String parseTarget(MethodSignature signature, JoinPoint joinPoint, String targetParam) {
        String target = targetParam;
        if (targetParam.startsWith("${") && targetParam.endsWith("}")) {
            targetParam = targetParam.replace("${", "").replace("}", "");
            String[] parameterNames = signature.getParameterNames();
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!targetParam.equals(parameterNames[i])) continue;
                Object arg = args[i];
                if (arg instanceof String) {
                    target = (String)arg;
                    continue;
                }
                if (arg instanceof Integer) {
                    target = String.valueOf((Integer)arg);
                    continue;
                }
                target = null;
                log.error("target\u5c5e\u6027\u76ee\u524d\u53ea\u652f\u6301String\u548cInteger\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u5f53\u524d\u53c2\u6570{}\u7684\u7c7b\u578b\u6682\u4e0d\u652f\u6301", (Object)targetParam);
            }
        }
        return target;
    }
}

