/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.http;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.web.HttpMethodEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.core.util.http.HttpGetWithEntity;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.multipart.MultipartFile;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    public static final String CHARSET = "UTF-8";

    public static String doPost(String apiUrl, String apiName, String json) {
        return HttpUtil.doPost(apiUrl, apiName, json, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json, boolean skipSsl) {
        String id;
        int statusCode;
        String httpStr;
        CloseableHttpClient httpClient;
        long start;
        block29: {
            start = System.currentTimeMillis();
            try {
                if (skipSsl) {
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
                    httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setDefaultRequestConfig(requestConfig).build();
                } else {
                    httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
                }
            }
            catch (Exception e) {
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post init httpClient error:" + e.getMessage());
            }
            httpStr = "";
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            statusCode = -999;
            id = StringUtil.hex32();
            log.info("doPost.id:" + id);
            try {
                httpPost.setConfig(requestConfig);
                if (StringUtils.isNotBlank((CharSequence)json)) {
                    StringEntity stringEntity = new StringEntity(json, CHARSET);
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                }
                httpPost.addHeader("traceId", MDC.get((String)"traceId"));
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block29;
            }
            catch (Exception ex) {
                try {
                    long end2 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end2));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                            response.close();
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil doPost error:" + ex2.getMessage());
                        }
                    }
                    long end3 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end3));
                    MDC.put((String)"API_NAME", (String)apiName);
                    if (!StringUtils.equals((CharSequence)apiName, (CharSequence)"es\u67e5\u8be2")) {
                        if (apiUrl.contains("wwsq/tsWwsqFjxx") || apiUrl.contains("storages/multipart/upload")) {
                            log.info("{}:request to:{},response code:{},cost {} ms,param.length:{}", new Object[]{id, apiUrl, statusCode, end3, json == null ? 0 : json.length()});
                        } else {
                            log.info("{}:request to:{},response code:{},cost {} ms,param:{}", new Object[]{id, apiUrl, statusCode, end3, json});
                        }
                        if (apiUrl.contains("zzgx/zzxxxz")) {
                            log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)(httpStr == null ? 0 : httpStr.length()));
                        } else {
                            log.info("{}:result:{}", new Object[]{id, httpStr});
                        }
                    }
                    try {
                        httpClient.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
            catch (IOException ex) {
                log.error("HttpUtil doPost error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        if (!StringUtils.equals((CharSequence)apiName, (CharSequence)"es\u67e5\u8be2")) {
            if (apiUrl.contains("wwsq/tsWwsqFjxx") || apiUrl.contains("storages/multipart/upload")) {
                log.info("{}:request to:{},response code:{},cost {} ms,param.length:{}", new Object[]{id, apiUrl, statusCode, end, json == null ? 0 : json.length()});
            } else {
                log.info("{}:request to:{},response code:{},cost {} ms,param:{}", new Object[]{id, apiUrl, statusCode, end, json});
            }
            if (apiUrl.contains("zzgx/zzxxxz")) {
                log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)(httpStr == null ? 0 : httpStr.length()));
            } else {
                log.info("{}:result:{}", new Object[]{id, httpStr});
            }
        }
        try {
            httpClient.close();
            return httpStr;
        }
        catch (IOException iOException) {
            return httpStr;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json, String contentType) {
        long start = System.currentTimeMillis();
        String httpStr = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            int statusCode;
            block24: {
                HttpPost httpPost = new HttpPost(apiUrl);
                CloseableHttpResponse response = null;
                statusCode = -999;
                try {
                    httpPost.setConfig(requestConfig);
                    if (StringUtils.isNotBlank((CharSequence)json)) {
                        StringEntity stringEntity = new StringEntity(json, CHARSET);
                        stringEntity.setContentType(contentType);
                        httpPost.setEntity((HttpEntity)stringEntity);
                    }
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    statusCode = response.getStatusLine().getStatusCode();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                    if (response == null) break block24;
                }
                catch (Exception ex) {
                    try {
                        long end2 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end2));
                        MDC.put((String)"API_NAME", (String)apiName);
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                            catch (IOException ex2) {
                                log.error("HttpUtil doPost error:" + ex2.getMessage());
                            }
                        }
                        long end3 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end3));
                        MDC.put((String)"API_NAME", (String)apiName);
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, json});
                        log.info("result:{}", new Object[]{httpStr});
                        throw throwable;
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException ex) {
                    log.error("HttpUtil doPost error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, json});
            log.info("result:{}", new Object[]{httpStr});
            return httpStr;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json, Map<String, String> headerMap) {
        long start = System.currentTimeMillis();
        String httpStr = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            int statusCode;
            block25: {
                HttpPost httpPost = new HttpPost(apiUrl);
                CloseableHttpResponse response = null;
                statusCode = -999;
                try {
                    httpPost.setConfig(requestConfig);
                    StringEntity stringEntity = new StringEntity(json, CHARSET);
                    if (headerMap != null) {
                        for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                            httpPost.addHeader(elem.getKey(), elem.getValue());
                        }
                    }
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    statusCode = response.getStatusLine().getStatusCode();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                    if (response == null) break block25;
                }
                catch (Exception ex) {
                    try {
                        long end2 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end2));
                        MDC.put((String)"API_NAME", (String)apiName);
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                                response.close();
                            }
                            catch (IOException ex2) {
                                log.error("HttpUtil post error:" + ex2.getMessage());
                            }
                        }
                        long end3 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end3));
                        MDC.put((String)"API_NAME", (String)apiName);
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, json});
                        log.info("result:{}", new Object[]{httpStr});
                        throw throwable;
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
                catch (IOException ex) {
                    log.error("HttpUtil post error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, json});
            log.info("result:{}", new Object[]{httpStr});
            return httpStr;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String url, List<MultipartFile> files, Map<String, String> otherParams, Map<String, String> headerParams) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headerParams != null && !headerParams.isEmpty()) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    String string = entry.getValue();
                    String string2 = entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    httpPost.setHeader(string2, string);
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (MultipartFile multipartFile : files) {
                if (multipartFile == null) continue;
                String string = multipartFile.getOriginalFilename();
                builder.addBinaryBody("file", multipartFile.getInputStream(), ContentType.MULTIPART_FORM_DATA, string);
            }
            ContentType contentType = ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8);
            if (otherParams != null && !otherParams.isEmpty()) {
                for (Map.Entry<String, String> entry : otherParams.entrySet()) {
                    String value = entry.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    builder.addTextBody(entry.getKey(), value, contentType);
                }
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = closeableHttpResponse.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            log.error("\u4f7f\u7528httpclint \u53d1\u9001\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error("httpclint\u5173\u95ed\u5f02\u5e38\uff1a{}", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, Map<String, Object> params) {
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        String httpStr = "";
        int statusCode = -999;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            block24: {
                HttpPost httpPost = new HttpPost(apiUrl);
                try {
                    httpPost.setConfig(requestConfig);
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                        pairList.add(pair);
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                    if (response == null) break block24;
                }
                catch (Exception ex) {
                    try {
                        long end2 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end2));
                        MDC.put((String)"API_NAME", (String)apiName);
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                                response.close();
                            }
                            catch (IOException ex2) {
                                log.error("HttpUtil post error:" + ex2.getMessage());
                            }
                        }
                        long end3 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end3));
                        MDC.put((String)"API_NAME", (String)apiName);
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, JSON.toJSONString(params)});
                        log.info("result:{}", new Object[]{httpStr});
                        throw throwable;
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
                catch (IOException ex) {
                    log.error("HttpUtil post error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString(params)});
            log.info("result:{}", new Object[]{httpStr});
            return httpStr;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostForBase64(String apiUrl, String apiName, Map<String, Object> params) {
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        String httpStr = "";
        int statusCode = -999;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            block25: {
                HttpPost httpPost = new HttpPost(apiUrl);
                try {
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Content-Type", "multipart/form-data");
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                        pairList.add(pair);
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        InputStream instream = entity.getContent();
                        httpStr = Base64.encode((InputStream)instream);
                    }
                    if (response == null) break block25;
                }
                catch (Exception ex) {
                    try {
                        long end2 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end2));
                        MDC.put((String)"API_NAME", (String)apiName);
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                            catch (IOException ex2) {
                                log.error("HttpUtil post error:" + ex2.getMessage());
                            }
                        }
                        long end3 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end3));
                        MDC.put((String)"API_NAME", (String)apiName);
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, JSON.toJSONString(params)});
                        if (!StringUtils.isNotBlank((CharSequence)httpStr)) throw throwable;
                        log.info("result.size:{}", new Object[]{httpStr.length()});
                        throw throwable;
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException ex) {
                    log.error("HttpUtil post error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString(params)});
            if (!StringUtils.isNotBlank((CharSequence)httpStr)) return httpStr;
            log.info("result.size:{}", new Object[]{httpStr.length()});
            return httpStr;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            MDC.put((String)"API_NAME", (String)apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doHttpsPost(String apiUrl, Map<String, Object> params, Map<String, String> header) {
        int statusCode;
        String httpStr;
        long start;
        block18: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = "";
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost httpPost = new HttpPost(apiUrl);
            try {
                httpPost.setConfig(requestConfig);
                httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                if (MapUtils.isNotEmpty(header)) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        httpPost.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                response = httpClient.execute((HttpUriRequest)httpPost);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block18;
            }
            catch (Exception ex) {
                try {
                    long end2 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end2));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                            response.close();
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end3 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end3));
                    if (apiUrl.contains("integrated/pictureInfo")) {
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, "\u5165\u53c2\u592a\u957f\uff0c\u4e0d\u8f93\u51fa"});
                    } else {
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, JSON.toJSONString(params)});
                    }
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        if (apiUrl.contains("integrated/pictureInfo")) {
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, "\u5165\u53c2\u592a\u957f\uff0c\u4e0d\u8f93\u51fa"});
        } else {
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString(params)});
        }
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doHttpsGet(String apiUrl, Map<String, Object> params) {
        int statusCode;
        String httpStr;
        long start;
        block12: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = "";
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            try {
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                URIBuilder uriBuilder = new URIBuilder(apiUrl);
                uriBuilder.addParameters(pairList);
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block12;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                            response.close();
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString(params)});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString(params)});
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream downloadFileStream(String apiUrl, String json) {
        long start = System.currentTimeMillis();
        ByteArrayOutputStream byteOutStream = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            int statusCode;
            String httpStr;
            block24: {
                httpStr = "";
                HttpPost httpPost = new HttpPost(apiUrl);
                CloseableHttpResponse response = null;
                statusCode = -999;
                try {
                    HttpEntity entity;
                    httpPost.setConfig(requestConfig);
                    StringEntity stringEntity = new StringEntity(json, CHARSET);
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200 && (entity = response.getEntity()) != null && entity.getContent() != null) {
                        byteOutStream = HttpUtil.cloneInputStream(entity.getContent());
                    }
                    if (response == null) break block24;
                }
                catch (Exception ex) {
                    try {
                        long end2 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end2));
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                            catch (IOException ex2) {
                                log.error("HttpUtil downloadFileStream error:" + ex2.getMessage());
                            }
                        }
                        long end3 = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end3));
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end3, json});
                        log.info("result:{}", new Object[]{httpStr});
                        throw throwable;
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException ex) {
                    log.error("HttpUtil downloadFileStream error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, json});
            log.info("result:{}", new Object[]{httpStr});
            return byteOutStream;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + e.getMessage());
        }
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                byteOutStream.write(buffer, 0, len);
            }
            byteOutStream.flush();
            return byteOutStream;
        }
        catch (IOException e) {
            log.warn("copy InputStream error\uff0c{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static String doGet(String url, String apiName, Map<String, Object> params) {
        return HttpUtil.doGet(url, apiName, params, null, false);
    }

    public static String doGet(String url, String apiName, Map<String, Object> params, Map<String, String> headerMap) {
        return HttpUtil.doGet(url, apiName, params, headerMap, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doGetInternal(String url, String apiName, Map<String, Object> params, Map<String, String> headerMap, boolean skipSSL) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block13: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = null;
            CloseableHttpClient httpClient = null;
            statusCode = -999;
            try {
                if (skipSSL) {
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            return true;
                        }
                    }).build();
                    SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                } else {
                    httpClient = HttpClients.createDefault();
                }
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (httpClient == null) break block13;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
                    log.info("result:{}", new Object[]{result});
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
        log.info("result:{}", new Object[]{result});
        return result;
    }

    public static String doGet(String url, String apiName, Map<String, Object> params, Map<String, String> headerMap, boolean skipSSL) {
        return HttpUtil.doGetInternal(url, apiName, params, headerMap, skipSSL);
    }

    private static String doGetForBase64Internal(String url, Map<String, Object> params, Map<String, String> headerMap, boolean skipSSL) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block18: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = "";
            CloseableHttpClient httpClient = null;
            statusCode = -999;
            try {
                if (skipSSL) {
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            return true;
                        }
                    }).build();
                    SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                } else {
                    httpClient = HttpClients.createDefault();
                }
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block18;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
                    if (url.contains("syd/business/download")) {
                        log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)result.length());
                    } else {
                        log.info("result:{}", new Object[]{result});
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
        if (url.contains("syd/business/download")) {
            log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)result.length());
        } else {
            log.info("result:{}", new Object[]{result});
        }
        return result;
    }

    public static String doGetForBase64(String url, Map<String, Object> params, Map<String, String> headerMap) {
        return HttpUtil.doGetForBase64Internal(url, params, headerMap, false);
    }

    public static String doGetForBase64(String url, Map<String, Object> params, Map<String, String> headerMap, boolean skipSSL) {
        return HttpUtil.doGetForBase64Internal(url, params, headerMap, skipSSL);
    }

    public static InputStream doGetForInputStream(String url, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        CloseableHttpClient httpClient;
        String apiUrl;
        StringBuffer param;
        long start;
        block12: {
            InputStream inputStream;
            block13: {
                start = System.currentTimeMillis();
                param = new StringBuffer();
                int i = 0;
                if (params != null) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        String key = entry.getKey();
                        if (i == 0) {
                            param.append("?");
                        } else {
                            param.append("&");
                        }
                        ++i;
                        param.append(key).append("=").append(params.get(key));
                    }
                }
                apiUrl = url + param;
                Object result = null;
                httpClient = HttpClients.createDefault();
                statusCode = -999;
                try {
                    HttpGet httpGet = new HttpGet(apiUrl);
                    if (headerMap != null) {
                        for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                            httpGet.addHeader(elem.getKey(), elem.getValue());
                        }
                    }
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block12;
                    inputStream = entity.getContent();
                    if (httpClient == null) break block13;
                }
                catch (Exception ex) {
                    try {
                        long end = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end));
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (httpClient != null) {
                            HttpClientUtils.closeQuietly((HttpClient)httpClient);
                        }
                        long end = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end));
                        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
                        throw throwable;
                    }
                }
                HttpClientUtils.closeQuietly((HttpClient)httpClient);
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
            return inputStream;
        }
        if (httpClient != null) {
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
        return null;
    }

    public static String doHttpsGetForBase64(String url, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block18: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = "";
            CloseableHttpResponse response = null;
            String httpStr = "";
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block18;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
                    if (url.contains("thirdcheck/downloadEInvoice")) {
                        log.info("result.length:{}", (Object)result.length());
                    } else {
                        log.info("result:{}", new Object[]{result});
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{apiUrl, statusCode, end, JSON.toJSONString((Object)param)});
        if (url.contains("thirdcheck/downloadEInvoice")) {
            log.info("result.length:{}", (Object)result.length());
        } else {
            log.info("result:{}", new Object[]{result});
        }
        return result;
    }

    public static String doGet(String url, String json) {
        int statusCode;
        String result;
        long start;
        block10: {
            start = System.currentTimeMillis();
            result = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGetWithEntity httpGetWithEntity = new HttpGetWithEntity(url);
                StringEntity httpEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
                httpGetWithEntity.setEntity((HttpEntity)httpEntity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGetWithEntity);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block10;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{url, statusCode, end, json});
                    if (!url.contains("office/pdf/export")) {
                        log.info("result:{}", new Object[]{result});
                    } else {
                        log.info("result.length:{}", result != null ? Integer.valueOf(result.length()) : "null");
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},response code:{},cost {} ms,param:{}", new Object[]{url, statusCode, end, json});
        if (!url.contains("office/pdf/export")) {
            log.info("result:{}", new Object[]{result});
        } else {
            log.info("result.length:{}", result != null ? Integer.valueOf(result.length()) : "null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJyxxPost(String jsonStr, String contentType, String url, String jkname, String bh, String ticket) {
        String responseContent = null;
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "application/json;charset=UTF-8";
            }
            CloseableHttpResponse httpResponse = null;
            CloseableHttpClient closeHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();
            httpPost.setConfig(config);
            httpPost.addHeader("Content-Type", contentType);
            if (StringUtils.isNotBlank((CharSequence)ticket)) {
                httpPost.addHeader("Authorization", "BasicAuth " + ticket);
            }
            if (jsonStr != null) {
                StringEntity stringEntity = new StringEntity(jsonStr, CHARSET);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            try {
                if (closeableHttpClient != null) {
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
                    Object parse = null;
                    parse = url.contains("bwyd") ? responseContent : JSON.parse((String)responseContent);
                    if (parse != null) {
                        responseContent = parse.toString();
                    }
                }
            }
            catch (IOException e) {
                log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
                responseContent = e.getMessage();
            }
            finally {
                try {
                    if (closeHttpClient != null) {
                        closeHttpClient.close();
                    }
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJyxxGet(String url, String ticket) {
        String responseContent = null;
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            CloseableHttpResponse httpResponse = null;
            CloseableHttpClient closeHttpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();
            httpGet.setConfig(config);
            if (StringUtils.isNotBlank((CharSequence)ticket)) {
                httpGet.addHeader("Authorization", "BasicAuth " + ticket);
            }
            try {
                if (closeableHttpClient != null) {
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
                    Object parse = null;
                    parse = url.contains("bwyd") ? responseContent : JSON.parse((String)responseContent);
                    if (parse != null) {
                        responseContent = parse.toString();
                    }
                }
            }
            catch (IOException e) {
                log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
                responseContent = e.getMessage();
            }
            finally {
                try {
                    if (closeHttpClient != null) {
                        closeHttpClient.close();
                    }
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClientPost(String url, String contentType, Map<String, String> param, Map<String, String> header, HttpEntity entity) {
        String result = "";
        String bh = StringUtil.hex32();
        log.info("bh:{},httpClientPost,\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}httpClientPost param: {} URL:{} header:{}", new Object[]{bh, LocalDateTime.now(), JSON.toJSONString(param), url, JSON.toJSONString(header)});
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                httpPost.setHeader("Content-Type", contentType);
            }
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(param)) {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if (entity != null) {
                httpPost.setEntity(entity);
            }
            try (CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n == 200) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)httpEntity);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        log.info("httpClientPost\u8bf7\u6c42result:{}", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClientPostForBase64(String url, String contentType, Map<String, String> param, Map<String, String> header, HttpEntity entity) {
        String result = "";
        String bh = StringUtil.hex32();
        log.info("bh:{},httpClientPost,\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}httpClientPost param: {} URL:{} header:{}", new Object[]{bh, LocalDateTime.now(), JSON.toJSONString(param), url, JSON.toJSONString(header)});
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                httpPost.setHeader("Content-Type", contentType);
            }
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(param)) {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if (entity != null) {
                httpPost.setEntity(entity);
            }
            try (CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n == 200) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (entity != null) {
                        InputStream instream = httpEntity.getContent();
                        result = Base64.encode((InputStream)instream);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        log.info("httpClientPost\u8bf7\u6c42result:{}", (Object)result.length());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRequest(HttpMethodEnum method, String url, String token, String content) {
        String responJson = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        InputStream inputStream = null;
        KeyStore trustStore = null;
        SSLContext sslcontext = null;
        try {
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            X509HostnameVerifier hostnameVerifier = new X509HostnameVerifier(){

                public void verify(String s, SSLSocket sslSocket) throws IOException {
                }

                public void verify(String s, X509Certificate x509Certificate) throws SSLException {
                }

                public void verify(String s, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext, hostnameVerifier)).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            Throwable throwable = null;
            if (connectionManager != null) {
                if (throwable != null) {
                    try {
                        connectionManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    connectionManager.close();
                }
            }
            httpClient = HttpClients.createDefault();
            HttpRequestBase httpReq = HttpUtil.getRequestEntity(method, token, url, content);
            httpResponse = httpClient.execute((HttpUriRequest)httpReq);
            inputStream = httpResponse.getEntity().getContent();
            responJson = HttpUtil.convertToString(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return responJson;
    }

    public static String httpHeaderPost(String jsonStr, String contentType, String url, Map<String, String> header) {
        return HttpUtil.httpHeaderPost(jsonStr, contentType, url, header, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpHeaderPost(String jsonStr, String contentType, String url, Map<String, String> header, String jkname, String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = StringUtil.hex32();
        }
        log.info("{}:\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{},httpHeaderPost,jsonStr: {} URL:{} contentType:{} header:{}", new Object[]{id, LocalDateTime.now(), jsonStr, url, contentType, header});
        String responseContent = null;
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "application/json;charset=UTF-8";
            }
            CloseableHttpResponse httpResponse = null;
            CloseableHttpClient closeHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", contentType);
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                StringEntity stringEntity = new StringEntity(jsonStr, CHARSET);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            try {
                if (closeableHttpClient != null) {
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
                }
            }
            catch (IOException e) {
                log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
                responseContent = e.getMessage();
            }
            finally {
                try {
                    if (closeHttpClient != null) {
                        closeHttpClient.close();
                    }
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
        }
        log.info("{}:\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a{},httpHeaderPost,URL:{} responseContent:{}", new Object[]{id, LocalDateTime.now(), url});
        return responseContent;
    }

    private static HttpRequestBase getRequestEntity(HttpMethodEnum method, String token, String uri, String content) throws UnsupportedEncodingException {
        switch (method.getNum()) {
            case 1: {
                HttpGet httpGet = new HttpGet(uri + content);
                httpGet.addHeader("Content-type", "application/json");
                httpGet.addHeader("X-Subject-Token", token);
                return httpGet;
            }
            case 2: {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.addHeader("Content-type", "application/json");
                httpPost.addHeader("X-Subject-Token", token);
                httpPost.setEntity((HttpEntity)new StringEntity(content, CHARSET));
                return httpPost;
            }
            case 3: {
                HttpPut httpPut = new HttpPut(uri);
                httpPut.addHeader("Content-type", "application/json");
                httpPut.addHeader("X-Subject-Token", token);
                httpPut.setEntity((HttpEntity)new StringEntity(content, CHARSET));
                return httpPut;
            }
            case 4: {
                HttpDelete httpDelete = new HttpDelete(uri + content);
                httpDelete.addHeader("Content-type", "application/json");
                httpDelete.addHeader("X-Subject-Token", token);
                return httpDelete;
            }
        }
        System.out.println("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5bf9");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadFile(String fileUrl) {
        byte[] bytes = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setConnectTimeout(5000);
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
            inputStream = http.getInputStream();
            if (inputStream != null) {
                bytes = FileUtils.convertToByteArray(inputStream);
                inputStream.close();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertToString(InputStream is) {
        String string;
        if (is == null) {
            return null;
        }
        BufferedReader bf = null;
        try {
            StringBuilder sb = new StringBuilder();
            String temp = "";
            bf = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((temp = bf.readLine()) != null) {
                sb.append(temp);
            }
            string = sb.toString();
            HttpUtil.closeStream(bf);
        }
        catch (IOException e) {
            e.printStackTrace();
            String string2 = null;
            return string2;
        }
        finally {
            HttpUtil.closeStream(bf);
            HttpUtil.closeStream(is);
        }
        HttpUtil.closeStream(is);
        return string;
    }

    private static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(120000);
        configBuilder.setSocketTimeout(120000);
        configBuilder.setConnectionRequestTimeout(120000);
        requestConfig = configBuilder.build();
    }
}

