/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.ght;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    private static final Logger logger = LoggerFactory.getLogger(AesUtil.class);
    private static final String ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static String encrypt(String content, String key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, (Key)secretKey, iv);
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25: " + e.getMessage());
        }
    }

    public static String decrypt(String encryptedContent, String key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, (Key)secretKey, iv);
            byte[] encryptedBytes = Base64.decodeBase64((String)encryptedContent);
            byte[] decrypted = cipher.doFinal(encryptedBytes);
            String result = new String(decrypted, StandardCharsets.UTF_8);
            return AesUtil.cleanJsonString(result);
        }
        catch (Exception e) {
            logger.error("AES\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25: " + e.getMessage());
        }
    }

    private static String cleanJsonString(String str) {
        int lastIndex;
        if (str == null || str.length() <= 1) {
            return str;
        }
        str = str.trim();
        while (str.length() > 0 && str.charAt(str.length() - 1) == '\u0000') {
            str = str.substring(0, str.length() - 1);
        }
        if ((str = str.trim()).length() > 0 && str.charAt(0) == '[') {
            int lastIndex2 = str.lastIndexOf(93);
            if (lastIndex2 > 0) {
                return str.substring(0, lastIndex2 + 1);
            }
        } else if (str.length() > 0 && str.charAt(0) == '{' && (lastIndex = str.lastIndexOf(125)) > 0) {
            return str.substring(0, lastIndex + 1);
        }
        return str;
    }

    public static boolean isJson(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        String trimmed = str.trim();
        return trimmed.startsWith("{") && trimmed.endsWith("}") || trimmed.startsWith("[") && trimmed.endsWith("]");
    }
}

