package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyQlrGxr;

import java.util.List;

/**
 * 权利人_关系人信息(GxYyQlrGxr)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYyQlrGxrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param gxrid 主键
     * @return 实例对象
     */
    GxYyQlrGxr get(String gxrid);

    /**
     * 新增数据
     *
     * @param gxYyQlrGxr 实例对象
     * @return 影响行数
     */
    void save(GxYyQlrGxr gxYyQlrGxr);

    /**
     * 修改数据
     *
     * @param gxYyQlrGxr 实例对象
     * @return 影响行数
     */
    void update(GxYyQlrGxr gxYyQlrGxr);

    /**
     * 批量新增或修改数据
     *
     * @param gxrList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyQlrGxr> gxrList);
    /**
     * 通过申请ID查询关系人集合
     *
     * @param sqid 申请ID
     * @return 影响行数
     */
    List<GxYyQlrGxr> list(String sqid);

    /**
     * 通过qlrid查询关系人集合
     *
     * @param qlrid 权利人ID
     * @return 结果集
     */
    List<GxYyQlrGxr> getByQlrid(String qlrid);
    /**
     * 通过qlrid查询关系人集合
     *
     * @param qlridList 权利人ID
     * @return 结果集
     */
    List<GxYyQlrGxr> getByQlridList(List<String> qlridList);

    /**
     * 通过gxrid删除数据
     *
     * @param gxrid 关系人ID
     * @return 影响行数
     */
    int delete(String gxrid);

    /**
     * 通过sqid集合查询关系人集合
     *
     * @param sqIdList 申请id集合
     * @return 结果集
     */
    List<GxYyQlrGxr> getBySqidList(List<String> sqIdList);

    /**
     * 通过qlrid集合查询关系人集合
     *
     * @param qlrIdList 权利人id集合
     * @return 结果集
     */
    List<GxYyQlrGxr> getListByQlrids(List<String> qlrIdList);

    /**
     * 通过qlrid删除数据
     *
     * @param qlrIdList 权利人ID
     * @return 影响行数
     */
    int deleteByQlrids(List<String> qlrIdList);

    void saveOrUpdate(GxYyQlrGxr gxYyQlrGxr);

    void deleteBySqid(String sqid);

    void deleteBySqidList(List<String> sqidList);

    GxYyQlrGxr getByQlridAndGxrlx(String sqid, String gxrlx);
}

