package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFjlxfl;

import java.util.List;

/**
 * 附件类型分类(GxYyFjlxfl)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-13 14:46:49
 */
public interface GxYyFjlxflRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyFjlxfl get(Integer id);

    /**
     * 新增数据
     *
     * @param gxYyFjlxfl 实例对象
     * @return 影响行数
     */
    void save(GxYyFjlxfl gxYyFjlxfl);

    /**
     * 修改数据
     *
     * @param gxYyFjlxfl 实例对象
     * @return 影响行数
     */
    void update(GxYyFjlxfl gxYyFjlxfl);

    /**
     * 根据申请类型查询分类信息
     * @param sqlx
     * @return
     */
    List<GxYyFjlxfl> getBySqlx(String sqlx);

    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYyFjlxflPO>
     * @author dingweiwei
     */
    List<GxYyFjlxfl> listBySqlx(String sqlx);

    /**
     * 根据sqlx删除
     * @param sqlx
     * @return:void
     * @author dingweiwei
     */
    void deleteBySqlx(String sqlx);

    /**
     * 保存
     * @param fjlxflPOList
     * @author dingweiwei
     */
    void insertBatchSomeColumn(List<GxYyFjlxfl> fjlxflPOList);

    GxYyFjlxfl getById(String fjflid);

    void saveOrUpdate(GxYyFjlxfl gxYyFjlxflPO);

    void deleteById(String id);

    GxYyFjlxfl getBySqlxAndZdbmAndfjlx(String sqlx, String zdDm, String fjlxdm);

    void saveOrUpdateDiff(GxYyFjlxfl fjlxflPO);
}

