package cn.gtmap.hlw.core.dto.sw.hs;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/18
 * @description 未成年子女信息
 */
@Data
public class SwHsWcnznxxDTO {
    /**
     * 交易方 UUID
     */
    private String jyfuuid;
    /**
     * 转让方承受方标志
     */
    private String zrfcsfbz;
    /**
     * 纳税人识别号码
     */
    private String nsrsbh;
    /**
     * 纳税人名称
     */
    private String nsrmc;
    /**
     * 身份证件类型代码
     */
    @ZdDzConfig(field="sfzjlxd", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String sfzjlxd;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
    /**
     * 国籍代码
     */
    @ZdDzConfig(field="gjdm", tableName = ZdDzConstant.ZD_DZ_GJ, dmToDm = true)
    private String gjdm;
    /**
     * 未成年子女证件类型
     */
    @JSONField(name = "wcnznzjlx_dm")
    @ZdDzConfig(field="wcnznzjlxdm", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String wcnznzjlxdm;
    /**
     * 未成年子女证件号码
     */
    private String wcnznzjhm;
    /**
     * 未成年子女姓名
     */
    private String wcnznxm;
    /**
     * 是否存在未成年人标志
     */
    private String czwcnbj;
}
