package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:18
 * @description 变更信息
 */
@Data
public class BgxxDTO implements Serializable {
    /**
     * 主键
     */
    private String id;

    /**
     * 申请ID
     */
    private String sqid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 面积
     */
    private Double mj;

    /**
     * 权利人姓名
     */
    private String qlrmc;

    /**
     * 权利人身份证件号码
     */
    private String qlrsfzjhm;

    /**
     * 规划用途代码
     */
    private String ghytdm;

    /**
     * 土地使用权类型代码
     */
    private String tdsyqlxdm;

    /**
     * 土地使用权类型名称
     */
    @ZdTypeConfig(field = "tdsyqlxdm", tableName = ZdTypeConstant.ZD_TYPE_TDSYQLX, dmToMc = true)
    private String tdsyqlxmc;

    /**
     * 房屋结构代码
     */
    private String fwjgdm;

    /**
     * 坐落脱敏
     */
    private String zlTm;

    /**
     * 权利人名称脱敏
     */
    private String qlrmcTm;

    /**
     * 权利人身份证件号码脱敏
     */
    private String qlrsfzjhmTm;

    /**
     * 抵押方式;字典项
     */
    private String dyfs;

    /**
     * 被担保主债权数额
     */
    private Double bdbzzqse;

    /**
     * 债务履行期限开始日期
     */
    private Date zwlxqxksrq;

    /**
     * 债务履行期限结束日期
     */
    private Date zwlxqxjsrq;

    /**
     * 土地抵押面积
     */
    private String tddymj;

    /**
     * 贷款方式代码;字典项
     */
    private String dkfsdm;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 权利类型;字典项
     */
    private String qllx;

    /**
     * 宗地/宗海权利性质
     */
    private String zdzhqlxz;

    /**
     * 房屋权利性质
     */
    private String fwqlxz;

    /**
     * 土地用途
     */
    private String tdyt;

    /**
     * 房屋用途
     */
    private String fwyt;

    /**
     * 房屋用途名称
     */
    @ZdTypeConfig(field = "fwyt", tableName = ZdTypeConstant.ZD_TYPE_FWYT, dmToMc = true)
    private String fwytmc;

    /**
     * 宗地面积
     */
    private String zdmj;

    /**
     * 实测建筑面积
     */
    private String fwjzmj;

    /**
     * 实测套内面积(专有建筑面积)
     */
    private String sctnmj;

    /**
     * 实测分摊面积(分摊建筑面积)
     */
    private String scftmj;

    /**
     * 使用期限
     */
    private String syqx;

    /**
     * 房屋结构
     */
    private String fwjg;

    /**
     * 房屋结构名称
     */
    @ZdTypeConfig(field = "fwjg", tableName = ZdTypeConstant.ZD_TYPE_FWJG, dmToMc = true)
    private String fwjgmc;

    /**
     * 房屋总层数
     */
    private String fwzcs;

    /**
     * 房屋所在层
     */
    private String fwszc;

    /**
     * 建筑年代（份）
     */
    private String jznf;

    /**
     * 产权来源
     */
    private String cqly;

    /**
     * 土地使用权面积
     */
    private String tdsyqmj;

    /**
     * 构筑物面积
     */
    private String gzwmj;

    /**
     * 构筑物规划用途
     */
    private String gzwghytdm;

    /**
     * 构筑物规划用途名称
     */
    private String gzwghytmc;

    /**
     * 供役地权利人名称
     */
    private String gydqlrmc;

    /**
     * 需役地权利人名称
     */
    private String xydqlrmc;

    /**
     * 地役权内容
     */
    private String dyqnr;

    /**
     * 变更不动产属性, 1：面积 2：用途 3：地址 4：楼层 0：其他
     */
    private String bgbdcsx;

    /**
     * 变更不动产其他属性
     */
    private String bgbdcqtsx;

    /**
     * 变更前登记信息
     */
    private String bgqdjxx;

    /**
     * 变更后登记信息
     */
    private String bghdjxx;
    /**
     * 变更不动产类型
     */
    private String bgbdclx;
}
