/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.coredk.utils;

import cn.hutool.poi.excel.ExcelWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DzkfExcelFileUtil {
    private static final Logger log = LoggerFactory.getLogger(DzkfExcelFileUtil.class);

    public static File getFile(File file, List<Map> dataList, ExcelWriter writer) {
        return DzkfExcelFileUtil.getFile(file, dataList, writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(File file, List<Map> dataList, ExcelWriter writer, Boolean isSetDefaultHeight) {
        if (CollectionUtils.isNotEmpty(dataList)) {
            Map map = dataList.get(0);
            int idx = 0;
            for (String key : map.keySet()) {
                writer.setColumnWidth(idx, 30);
                ++idx;
            }
            int size = dataList.size() + 1;
            if (isSetDefaultHeight.booleanValue()) {
                for (int i = 0; i < size; ++i) {
                    writer.setRowHeight(i, 20);
                }
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                writer.flush((OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u5bfc\u51faExcel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                writer.close();
                file.delete();
            }
        }
        return file;
    }

    public static void addMergedRowWithStyles(ExcelWriter writer, int rowNum, int leftStartCol, int leftEndCol, String leftContent, HorizontalAlignment leftAlignment, int rightStartCol, int rightEndCol, String rightContent, HorizontalAlignment rightAlignment) {
        writer.merge(rowNum, rowNum, leftStartCol, leftEndCol, (Object)leftContent, false);
        Cell leftCell = writer.getOrCreateCell(rowNum, leftStartCol);
        CellStyle leftStyle = writer.createCellStyle();
        leftStyle.setAlignment(leftAlignment);
        leftCell.setCellStyle(leftStyle);
        writer.merge(rowNum, rowNum, rightStartCol, rightEndCol, (Object)rightContent, false);
        Cell rightCell = writer.getOrCreateCell(rowNum, rightStartCol);
        CellStyle rightStyle = writer.createCellStyle();
        rightStyle.setAlignment(rightAlignment);
        rightCell.setCellStyle(rightStyle);
    }
}

