/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.es;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ESClient {
    @Autowired
    private RestHighLevelClient client;

    public boolean createIndex(String index, Settings.Builder settings, String mappingJson) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(index).settings(settings).mapping(mappingJson, XContentType.JSON);
        try {
            CreateIndexResponse resp = this.client.indices().create(request, RequestOptions.DEFAULT);
            return resp.isAcknowledged();
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.BAD_REQUEST && e.getMessage().contains("resource_already_exists_exception")) {
                System.out.println("\u7d22\u5f15\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u3002");
                return true;
            }
            throw e;
        }
    }

    public boolean deleteIndex(String index) throws IOException {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        AcknowledgedResponse resp = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return resp.isAcknowledged();
    }

    public IndexResponse createDocument(String index, String id, Object doc) throws IOException {
        IndexRequest request = new IndexRequest(index).id(id).source(JSON.toJSONString((Object)doc), XContentType.JSON);
        return this.client.index(request, RequestOptions.DEFAULT);
    }

    public IndexResponse createDocument(String index, Object doc) throws IOException {
        IndexRequest request = new IndexRequest(index).source(JSON.toJSONString((Object)doc), XContentType.JSON);
        return this.client.index(request, RequestOptions.DEFAULT);
    }

    public GetResponse getDocument(String index, String id) throws IOException {
        GetRequest request = new GetRequest(index, id);
        return this.client.get(request, RequestOptions.DEFAULT);
    }

    public boolean deleteDocument(String index, String id) throws IOException {
        DeleteRequest request = new DeleteRequest(index, id);
        return this.client.delete(request, RequestOptions.DEFAULT).getResult() == DocWriteResponse.Result.DELETED;
    }

    public UpdateResponse updateDocument(String index, String id, Object doc) throws IOException {
        UpdateRequest request = new UpdateRequest(index, id).doc(JSON.toJSONString((Object)doc), XContentType.JSON);
        return this.client.update(request, RequestOptions.DEFAULT);
    }

    public SearchResponse searchDocuments(String index, SearchSourceBuilder source) throws IOException {
        SearchRequest request = new SearchRequest(new String[]{index}).source(source);
        return this.client.search(request, RequestOptions.DEFAULT);
    }

    public <T> BulkResponse bulkCreateDocument(String index, List<Map<String, T>> dataList) throws IOException {
        BulkRequest request = new BulkRequest();
        for (Map<String, T> item : dataList) {
            String id = item.keySet().iterator().next();
            T doc = item.get(id);
            request.add(new IndexRequest(index).id(id).source(JSON.toJSONString(doc), XContentType.JSON));
        }
        return this.client.bulk(request, RequestOptions.DEFAULT);
    }

    public BulkResponse bulkDeleteDocument(String index, List<String> idList) throws IOException {
        BulkRequest request = new BulkRequest();
        for (String id : idList) {
            request.add(new DeleteRequest(index, id));
        }
        return this.client.bulk(request, RequestOptions.DEFAULT);
    }
}

