package cn.gtmap.hlw.core.dto.forward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 加密请求DTO
 *
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a
 * @version 1.0
 * @description 接收前端加密后的请求数据
 */
@Data
@ApiModel("加密请求参数")
public class EncryptedRequestDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "加密后的请求数据", required = true)
    private String encryptedData;

    @ApiModelProperty(value = "RSA加密的AES密钥", required = true)
    private String rsaKey;

    @ApiModelProperty(value = "RSA私钥（如需要）")
    private String rsaPrivateKey;
}

