package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.WctJyJfxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJyJfxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyJfxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyJfxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJyJfxx 实例对象
     * @return 影响行数
     */
    void save(WctJyJfxx wctJyJfxx);

    /**
     * 修改数据
     *
     * @param wctJyJfxx 实例对象
     * @return 影响行数
     */
    void update(WctJyJfxx wctJyJfxx);

    /**
     * 批量新增数据
     *
     * @param wctJyJfxxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJyJfxx> wctJyJfxxList);

    /**
     * 根据map查询
     *
     * @param map 实例对象
     * @return List<WctJyJfxx>
     */
    List<WctJyJfxx> getListByMap(Map<String, Object> map);

    /**
     * 根据sfxxid查询
     *
     * @param sfxxid 实例对象
     * @return List<WctJyJfxx>
     */
    List<WctJyJfxx> listBySfxxid(String sfxxid);

    List<WctJyJfxx> listBySqid(String sqid);

    /**
     * 批量删除数据
     *
     * @param sfxxidList 实例对象
     * @return 影响行数
     */
    void deleteBySfxxidList(List<String> sfxxidList);

    /**
     * 根据jfxxid删除
     *
     * @param jfxxid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delete(String jfxxid);
}

