package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.HlwSqxxDy;

import java.util.List;

/**
 * 申请信息打印内容表(hlw_sqxx_dy)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2025-06-24 09:26:36
 */
public interface HlwSqxxDyRepository {

    /**
     * 通过申请id查询集合
     *
     * @param sqid 申请id
     */
    HlwSqxxDy getBySqid(String sqid);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 保存或更新打印信息
     */
    void saveOrUpdate(HlwSqxxDy hlwSqxxDy);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据sqid删除打印信息
     */
    void deleteBySqid(List<String> sqidList);
}

