package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.jfxm.ZdJfxmQueryDTO;
import cn.gtmap.hlw.core.model.GxYyZdJfxm;

import java.util.List;

/**
 * 缴费项目(GxYyZdJfxm)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-26 18:54:25
 */
public interface GxYyZdJfxmRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZdJfxm get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZdJfxm 实例对象
     * @return 影响行数
     */
    void save(GxYyZdJfxm gxYyZdJfxm);

    /**
     * 修改数据
     *
     * @param gxYyZdJfxm 实例对象
     * @return 影响行数
     */
    void update(GxYyZdJfxm gxYyZdJfxm);

    /**
     * 根据sfxmdm查询数据
     *
     * @param sfxmdmList 实例对象
     * @return 影响行数
     */
    List<GxYyZdJfxm> listBySfxmdmList(List<String> sfxmdmList);

    /**
     * 根据sfxmdm查询数据
     *
     * @return 影响行数
     */
    List<GxYyZdJfxm> getAll();

    /**
     * 根据sfxmdm查询数据
     *
     * @param sfxmdm 实例对象
     * @return 影响行数
     */
    GxYyZdJfxm getBySfxmdm(String sfxmdm);

    /**
     * 根据sfxmdm、qydm查询数据
     *
     * @param sfxmdmList 实例对象
     * @param qydm
     * @return 影响行数
     */
    List<GxYyZdJfxm> listBySfxmdmListAndQydm(List<String> sfxmdmList, String qydm);

    /**
     * 根据qydm查询数据
     *
     * @param qydm 实例对象
     * @return 影响行数
     */
    List<GxYyZdJfxm> listByQydm(String qydm);

    /**
     * 根据sfxmdm、qydm查询数据
     *
     * @param idList 实例对象
     * @param qydm
     * @return 影响行数
     */
    List<GxYyZdJfxm> listByIdListAndQydm(List<String> idList, String qydm);

    /**
     * 分页查询缴费项目
     *
     * @param paramsDTO 查询参数
     * @return 分页结果
     */
    PageInfo<GxYyZdJfxm> queryPage(ZdJfxmQueryDTO paramsDTO);

    /**
     * 保存或更新缴费项目
     *
     * @param gxYyZdJfxm 缴费项目
     */
    void saveOrUpdate(GxYyZdJfxm gxYyZdJfxm);

    /**
     * 根据ID删除缴费项目
     *
     * @param id 主键
     */
    void delete(String id);
}

