package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.djyy.ZdDjyyPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdDjyy;

import java.util.List;

/**
 * 申请类型与登记原因关联表(GxYyZdDjyy)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-26 18:52:12
 */
public interface GxYyZdDjyyRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id
     * @return 实例对象
     */
    GxYyZdDjyy get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZdDjyy 实例对象
     * @return 影响行数
     */
    void save(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 修改数据
     *
     * @param gxYyZdDjyy 实例对象
     * @return 影响行数
     */
    void update(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 获取数据
     *
     * @param sqlx   申请类型
     * @param xyqydm 区域代码
     * @return 影响行数
     */
    List<GxYyZdDjyy> getGxYyZdDjyyList(String sqlx, String xyqydm);
    /**
     * 获取数据
     *
     * @param sqlxList   申请类型集合
     * @param xyqydm 区域代码
     * @return 影响行数
     */
    List<GxYyZdDjyy> getBySqlxList(List<String> sqlxList, String xyqydm);

    /**
     * 根据申请类型查询列表
     */
    List<GxYyZdDjyy> listBySqlx(String sqlx);

    /**
     * 根据sqlx和代码查询名称
     *
     * @param sqlx
     * @param dm
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getMcBySqlxAndDm(String sqlx, String dm);

    /**
     * 根据sqlx和代码查询名称
     *
     * @param sqlx
     * @param djyy
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getRedisMcBySqlxAndDm(String sqlx, String djyy);


    /**
     *分页查询
     * @param paramsDTO
     * @return
     */

    PageInfo<GxYyZdDjyy> queryPage(ZdDjyyPageParamsDTO paramsDTO);

    /**
     * 删除
     * @param id
     * @return 删除数据的条数
     */
    int delete(String id);

    /**
     * 获取GxYyZdDjyy表全部数据
     * @return GxYyZdDjyy集合
     */
    List<GxYyZdDjyy> getAll();

    /**
     * 保存更新
     * @param gxYyZdDjyy
     */
    void saveOrUpdate(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 批量保存或更新
     */
    void saveOrUpdateBatch(List<GxYyZdDjyy> zdDjyyList);

    /**
     * 批量插入（部分字段）
     */
    void insertBatchSomeColumn(List<GxYyZdDjyy> zdDjyyList);

    /**
     * 按申请类型删除
     */
    void deleteBySqlx(String sqlx);
    /**
     * 查询
     * @param sqlx
     * @param djyy
     * @return:cn.gtmap.hlw.domain.dict.model.GxYyZdDjyy
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdDjyy getBySqlxAndDm(String sqlx, String djyy);
}

