package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.sign.tz.MySignFlowTzParamDTO;
import cn.gtmap.hlw.core.dto.sign.tz.MySignFlowTzResultDTO;
import cn.gtmap.hlw.core.model.GxYySqxxYq;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * 云签记录表(GxYySqxxYq)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:51
 */
public interface GxYySqxxYqRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param qsrwid 主键
     * @return 实例对象
     */
    GxYySqxxYq get(String qsrwid);

    /**
     * 通过qsrwid集合查询集合数据
     *
     * @param qsrwidList 主键集合
     * @return 实例对象
     */
    List<GxYySqxxYq> list(List<String> qsrwidList);

    /**
     * 新增数据
     *
     * @param gxYySqxxYq 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxYq gxYySqxxYq);

    /**
     * 新增数据
     *
     * @param gxYySqxxYq 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxYq gxYySqxxYq);

    /**
     * 批量更新或保存
     *
     * @param gxYySqxxYqList 实例对象
     */
    void saveOrUpdateBatch(List<GxYySqxxYq> gxYySqxxYqList);

    /**
     * 修改数据
     *
     * @param gxYySqxxYq 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxYq gxYySqxxYq);

    /**
     * 通过slbh查询数据
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxYq> getBySlbh(String slbh);

    /**
     * 通过slbh、jddm查询数据
     *
     * @param slbh 受理编号
     * @param jddm 节点代码
     * @return 实例对象
     */
    GxYySqxxYq getBySlbhAndJddm(String slbh, String jddm);

    /**
     * 通过slbh、jddm查询数据
     *
     * @param slbh 受理编号
     * @param jddm 节点代码
     * @return 实例对象
     */
    List<GxYySqxxYq> getListBySlbhAndJddm(String slbh, String jddm);

    /**
     * 通过slbh、csdm查询数据
     *
     * @param slbh 受理编号
     * @param csdm 厂商代码
     * @return 实例对象
     */
    List<GxYySqxxYq> getListBySlbhAndCsdm(String slbh, String csdm);

    /**
     * 通过slbh、jddm查询数据
     *
     * @param slbh 受理编号
     * @param jddm 节点代码
     * @param csdm 厂商代码
     * @return 实例对象
     */
    GxYySqxxYq getBySlbhLikeAndJddmAndCsdm(String slbh, String jddm, String csdm);

    /**
     * 查询数据
     *
     * @param qsrWid
     * @param iszf
     * @return 实例对象
     */
    GxYySqxxYq getByParams(String qsrWid, String iszf);

    /**
     * 根据流水号查询签署任务
     * @param lsh
     * @return
     */
    GxYySqxxYq getByLsh(String lsh);

    /**
     * 根据流水号或者签署任务id获取签署信息
     * @param qsrwid
     * @param lsh
     * @return
     */
    GxYySqxxYq getSqxxYqOr(String qsrwid, String lsh);

    /**
     * 我的云签台账分页
     * @param paramsDTO
     * @return
     */
    IPage<MySignFlowTzResultDTO> getMySignFlowByPage(MySignFlowTzParamDTO paramsDTO);

    /**
     * 通过slbhList获取集合
     * @param slbhList
     * @return List<GxYySqxxYq>
     */
    List<GxYySqxxYq> getBySlbhList(List<String> slbhList);
}

