package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxHtxx;

import java.util.List;

/**
 * (GxYySqxxHtxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYySqxxHtxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxxHtxx get(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxHtxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxHtxx gxYySqxxHtxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxHtxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxHtxx gxYySqxxHtxx);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxHtxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxHtxx gxYySqxxHtxx);

    /**
     * 获取数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    List<GxYySqxxHtxx> getHtxxBySlbh(String slbh);

    /**
     * 通过SQID集合查询集合数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxHtxx> list(List<String> sqidList);

    /**
     * 通过sqidList集合删除数据
     *
     * @param sqidList
     * @return 实例对象
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 根据slbh删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    void delete(String slbh);

    /**
     * 批量更新或保存数据
     *
     * @param gxYySqxxHtxxList
     * @return 实例对象
     */
    void saveOrUpdateBatch(List<GxYySqxxHtxx> gxYySqxxHtxxList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 获取相同类型合同号的最大值
     */
    String getMaxWthth(String wthth);
}

