package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.dto.sqxx.ghxx.tz.GhxxTzParamsDTO;
import cn.gtmap.hlw.core.model.GxYySqxxGhxx;
import cn.gtmap.hlw.core.model.query.WshSqxxGhxxSpxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * (GxYySqxxGhxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYySqxxGhxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYySqxxGhxx get(String id);

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYySqxxGhxx> list(String sqid);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 申请ID
     * @return 实例对象
     */
    List<GxYySqxxGhxx> list(List<String> sqidList);

    /**
     * 新增数据
     *
     * @param gxYySqxxGhxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxGhxx gxYySqxxGhxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxGhxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxGhxx gxYySqxxGhxx);

    /**
     * 批量新增或修改数据
     *
     * @param gxYySqxxGhxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxGhxx> gxYySqxxGhxxList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 实例对象
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 通过主键集合删除数据
     *
     * @param ghxxidList 实例对象
     * @return 影响行数
     */
    int deleteBatchIds(List<String> ghxxidList);

    /**
     * 通过slbh查询数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    GxYySqxxGhxx getBySlbh(String slbh);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    List<GxYySqxxGhxx> getListBySlbh(String slbh);

    /**
     * 分页查询
     *
     * @param ghxxTzParamsDTO
     * @param page
     * @return 影响行数
     */
    IPage<WshSqxxGhxxSpxxQuery> wshTz(GhxxTzParamsDTO ghxxTzParamsDTO, BasePage page);

    /**
     * 分页查询
     *
     * @param ghxxTzParamsDTO
     * @param page
     * @return 影响行数
     */
    IPage<WshSqxxGhxxSpxxQuery> yshTz(GhxxTzParamsDTO ghxxTzParamsDTO, BasePage page);
}

