package cn.gtmap.hlw.core.model.history;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史--(HgxYySqxxSpxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:25:43
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxSpxx implements Serializable {
    private static final long serialVersionUID = -1726741077348979734L;
    /**
     * 审批ID
     */
    private String spid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 申请id
     */
    private String sqid;

    /**
     * 审批信息
     */
    private String spxx;

    /**
     * 审批状态
     */
    private String spzt;

    /**
     * 审批人员
     */
    private String spry;

    /**
     * 审批时间
     */
    private Date spsj;

    /**
     * 节点名称(登记updateslzt传的slztmc)
     */
    private String jdmc;

    /**
     * 审批状态名称
     */
    private String spztmc;

    /**
     * 审批人员名称
     */
    private String sprymc;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 数据来源(1：登记3.0预审流程，
     * 2：登记3.0一体化流程,
     * 3：登记3.0线下流程,
     * 4：税务系统，
     * 5：登记2.0,0：互联网系统管理员的预审，
     * 6：互联网系统广电用户预审，7：交易备案系统)
     **/
    private String sjly;

    /**
     * 上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)
     */
    private String sbgjyczt;

    /**
     * 审核部门ID
     */
    private String shbmid;

    /**
     * 登记受理状态
     */
    private String djslzt;

    /**
     * 申请人id
     */
    private String sqrid;

    /**
     * 0:未删除，1：删除
     */
    private String isDelete;

    /**
     * 过户信息id
     */
    private String ghxxid;


}

