package cn.gtmap.hlw.core.model.history;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 历史--(HgxYySqxxHtxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:20:45
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxHtxx implements Serializable {
    private static final long serialVersionUID = -2174345780552226359L;
    /**
     * 申请id
     */
    private String sqid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 交易价格
     */
    private Double jyjg;

    /**
     * 付款方式
     */
    private String fkfs;

    /**
     * 首付款
     */
    private Double sfk;

    /**
     * 贷款种类
     */
    private String dkzl;

    /**
     * 申请贷款
     */
    private Double sqdk;

    /**
     * 是否通过代理
     */
    private String sftgdl;

    /**
     * 是否进行资金监管
     */
    private String sfzjjg;

    /**
     * 监管金额
     */
    private Double jgje;

    /**
     * 交付方式
     */
    private String jffs;

    private String jfqx;

    /**
     * 税费承担
     */
    private String sfcd;

    /**
     * 付款截至日期（YYYY-MM-DD）
     */
    private String fkjzrq;

    private String htqdrq;

    /**
     * 是否普通住房（0 否 1 是 ）
     */
    private String sfptzf;

    /**
     * 合同金额
     */
    private Double htje;

    /**
     * 单价
     */
    private Double dj;

    /**
     * 交易方式代码
     */
    private String jyfsdm;

    /**
     * 房屋交付日期（YYYY-MM-DD)
     */
    private String fwjfrq;

    /**
     * 不动产项目名称
     */
    private String xmmc;

    /**
     * 备案日期
     */
    private String barq;

    /**
     * 定金
     */
    private String yhdj;

    /**
     * 商贷金额
     */
    private String yhsdje;

    /**
     * 公积金贷款金额
     */
    private String yhgjjdkje;

    /**
     * 合同总额
     */
    private Double htze;

    /**
     * 备案状态代码（1：已备案0：未备案）
     */
    private String baztdm;

    /**
     * 成交价是否含税   0 否 1 是
     */
    private String cjjsfhs;

    /**
     * 房产证发证时间
     */
    private String fczfzsj;

    /**
     * 上次交易登记时间
     */
    private String scjydjsj;

    /**
     * 不含增值税金额
     */
    private Double bhzzsje;

    /**
     * 含增值税金额
     */
    private Double hzzsje;

    /**
     * 增值税金额
     */
    private Double zzsje;

    /**
     * 交易份额
     */
    private Double jyfe;

    /**
     * 监管编号
     */
    private String jgbh;

    /**
     * 合同坐落
     */
    private String htzl;

    /**
     * 合同义务人名称
     */
    private String htywrmc;

    /**
     * 其他约定事项
     */
    private String qtydsx;

    /**
     * 贷款银行
     */
    private String dkyh;

    /**
     * 合同约定登记时间
     */
    private String htyddjsj;

    /**
     * 人才劵金额
     */
    private String rcqje;

    /**
     * 违约金金额
     */
    private String wyjje;

    /**
     * 产籍号
     */
    private String fccjh;

    /**
     * 房地产交易时间（YYYY-MM-DD）
     */
    private String fdcjysj;

    /**
     * 签约类型（0：线上签订 1：线下签订）
     */
    private String qylx;

    /**
     * 是否签署（0：无合同 1：有合同）
     */
    private String sfqs;

    /**
     * 是否交房即发证（1：是，0：否）
     */
    private String sfjfjfz;

    /**
     * 交房即发证备注
     */
    private String jfjfzbz;

    /**
     * 交易合同id（交易返回htid）
     */
    private String jyhtid;

    /**
     * 自付款金额（单位：元）
     */
    private Double zfkje;

    /**
     * 其他款项金额（单位：元）
     */
    private Double qtkxje;

    /**
     * 付款金额（单位：元）
     */
    private Double fkje;

    /**
     * 付款期数
     */
    private Integer fkqs;

    /**
     * 约定登记日期
     */
    private String yddjrq;

    /**
     * 土地处理方式（zd_type表对照）
     */
    private String tdclfs;

    /**
     * 土地处理方式其他
     */
    private String tdclfsjqt;

    /**
     * 税费约定方式（zd_type表对照）
     */
    private String sfydfs;

    /**
     * 佣金约定方式（zd_type表对照）
     */
    private String yjydfs;

    /**
     * 争议解决方式（zd_type表对照）
     */
    private String zyjjfs;

    /**
     * 合同份数
     */
    private Integer htfs;

    /**
     * 卖方合同份数
     */
    private Integer salerhtfs;

    /**
     * 买方合同份数
     */
    private Integer buyerhtfs;

    /**
     * 委托合同号
     */
    private String wthth;

    /**
     * 付款期限1（YYYY-MM-DD）
     */
    private String fkqx1;

    /**
     * 付款金额1（单位：元）
     */
    private Double fkje1;

    /**
     * 付款期限2（YYYY-MM-DD）
     */
    private String fkqx2;

    /**
     * 付款金额2（单位：元）
     */
    private Double fkje2;

    /**
     * 付款期限3（YYYY-MM-DD）
     */
    private String fkqx3;

    /**
     * 付款金额3（单位：元）
     */
    private Double fkje3;

    /**
     * 首付款期限（YYYY-MM-DD）
     */
    private String sfkqx;

    /**
     * 贷款期限（YYYY-MM-DD）
     */
    private String dkqx;

    /**
     * 交易编号
     */
    private String jybh;

    /**
     * 房屋基本情况其他
     */
    private String fwjbqkqt;

    /**
     * 违约金2（单位：元）
     */
    private Double wyj2;

    /**
     * 违约金3（单位：元）
     */
    private Double wyj3;

    /**
     * 违约金其他
     */
    private String wyjqt;

    /**
     * 付款方式其他
     */
    private String fkfsqt;

    /**
     * 违约金4（单位：元）
     */
    private Double wyj4;

    /**
     * 佣金约定方式其他
     */
    private String yjydfsqt;

    /**
     * 税费约定方式
     */
    private String sfydfsqt;

    /**是否摇号限售房源（1 是，0 否）*/
    private String sfyhfy;

    /**是是否摇号限售房源备注*/
    private String sfyhfybz;

    /**税费承担说明*/
    private String sfcdsm;
}

