package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2025/5/31 15:20
 * @description 定时任务日志(GxYyDsrwRwdzLog)表实体类BO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDsrwRwdzLog implements Serializable {

    private static final long serialVersionUID = -6919142232349627812L;

    /**
     * 主键
     */
    private String id;

    /**
     * 定时任务id
     */
    private String dsrwid;

    /**
     * 任务名称
     */
    private String rwmc;

    /**
     * 修改前任务状态 0：暂停，1：启用
     */
    private String xgqzt;

    /**
     * 修改后任务状态 0：暂停，1：启用'
     */
    private String xghzt;

    /**
     * 状态修改时间
     */
    private Date xgsj;
}

