package cn.gtmap.hlw.core.enums.qlr;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/8 10:57
 * @description Cqbjsq
 */
@Getter
@AllArgsConstructor
public enum CqbjsqEnum {

    /**
     * 授权结果 （0:待授权，1：已授权，2：拒绝授权，3：授权已过期，4：授权请求作废,发起人重新发起）',
     */
    SQJG_DSQ (0, "待授权"),

    SQJG_YSQ (1, "已授权"),

    SQJG_JJSQ (2, "拒绝授权"),

    SQJG_SQYGQ (3, "授权已过期"),

    SQJG_SQQQZF (4, "授权请求作废"),

    NO_DATA (5, "查询为空"),

    /**否作废*/
    ISZF_SUCCESS (1, "成功"),

    ISZF_FAILURE (0, "失败");

    private Integer code;

    private String msg;

    public static String getMsg(Integer code) {
        for (CqbjsqEnum xq : CqbjsqEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
