package cn.gtmap.hlw.core.enums.dict.fw;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 房屋套次类型
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum FwtcEnum {

    /**
     * 第零套
     */
    FWTC_DLT("0", "第零套"),

    /**
     * 第一套
     */
    FWTC_DYT("1", "第一套"),
    /**
     * 第二套
     */
    FWTC_DET("2", "第二套"),
    /**
     * 其他套
     */
    FWTC_QTT("9", "其他套");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (FwtcEnum xq : FwtcEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

