package cn.gtmap.hlw.core.dto.zjcj;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/5/21
 * @description 申请信息
 */
@Data
public class ZjHlwSqxxXmxxDTO {
    /**
     * 项目信息（包含预告预抵押）
     */
    @ZdDzConfig(field = "hlwXmxx", tableName = "", isBean = true)
    private ZjHlwXmxxDTO hlwXmxx;
    /**
     * 不动产单元信息
     */
    @ZdDzConfig(field = "hlwSqxxBdcdyxx", tableName = "", isBean = true)
    private ZjHlwSqxxBdcdyxxDTO hlwSqxxBdcdyxx;
    /**
     * 预告信息（包含预告预抵押）
     */
    @ZdDzConfig(field = "hlwSqxxYgxx", tableName = "", isBean = true)
    private ZjHlwSqxxYgxxDTO hlwSqxxYgxx;
    /**
     * 权利人信息（预告的是买方）（预抵押是银行）
     */
    @ZdDzConfig(field = "hlwSqxxQlrxxList", tableName = "", isList = true)
    private List<ZjHlwSqxxQlrxxDTO> hlwSqxxQlrxxList;
    /**
     * 义务人信息（预告的是开发公司）（预抵押是买方）
     */
    @ZdDzConfig(field = "hlwSqxxYwrxxList", tableName = "", isList = true)
    private List<ZjHlwSqxxQlrxxDTO> hlwSqxxYwrxxList;
    /**
     * 债务人信息（默认买方，可以修改）
     */
    @ZdDzConfig(field = "hlwSqxxZwrxxList", tableName = "", isList = true)
    private List<ZjHlwSqxxQlrxxDTO> hlwSqxxZwrxxList;
    /**
     * 物流信息（页面补录）
     */
    @ZdDzConfig(field = "hlwSqxxWlxx", tableName = "", isBean = true)
    private ZjHlwSqxxWlxxDTO hlwSqxxWlxx;
    /**
     * 附件信息
     */
    private List<ZjHlwSqxxFjxxDTO> hlwSqxxFjxxList;
}
