package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2023/6/7 22:24
 * @description UnitSqxxDTO
 */
@Data
public class UnitSqxxDTO implements Serializable {
    /**ID主键 */
    private String id;

    /**申请人用户GUID */
    private String applyUserGuid;

    /**单位名称 */
    private String orgName;

    /**证件号码（营业执照） */
    private String zjh;

    /**是否同意（0：不同意，1：同意，2：待审核） */
    private String isAgree;

    /**审批人用户GUID */
    private String approvalUserGuid;

    /**创建时间*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date createTime;

    /**修改时间*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date updateTime;

    /**审核意见*/
    private String shyj;


}
