package cn.gtmap.hlw.core.dto.sqxx.lyzx;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/5/30 14:16
 * @description 留言咨询台账查询出参
 */
@Data
public class LyzxSaveDTO {


    /**
     * 申请id
     */
    private String sqid;

    /**
     * 诉求编号
     */
    private String sqbh;

    /**
     * 诉求主题
     */
    private String sqzt;

    /**
     * 诉求人
     */
    private String sqr;

    /**
     * 诉求日期（创建时间）
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date cjsj;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 诉求内容
     */
    private String sqnr;

    /**
     * 查看次数（热度）
     */
    private Integer ckcs;

    /**
     * 回复时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date hfsj;

    /**
     * 回复单位
     */
    private String hfdw;

    /**
     * 回复内容
     */
    private String hfnr;

    /**
     * 诉求状态（1：待处理，2：已办结）
     */
    private Integer bjzt;

    /**
     * 诉求类型   1:投诉   2:咨询   3:资料查询
     */
    private String sqlx;

    /**
     * 用户id
     */
    private String userid;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 服务大厅
     */
    private String fwdt;

    /**
     * 诉求部门
     */
    private String sqbm;

    /**
     * 诉求窗口
     */
    private String sqck;

    /**
     * 导巡台
     */
    private String dxt;

    /**
     * 科室
     */
    private String ks;

    /**
     * 诉求人所在部门（GX_YY_ORG.ORG_ID）
     */
    private String sqr_org_id;

    /**
     * 是否公开（0否1是）
     */
    private String sfgk;

    /**
     * 审核状态（0：未审核 1：审核通过，2：审核不通过 ）
     */
    private Integer shzt;

    /**
     * 是否公开回复（0否1是）
     */
    private String sfgkhf;

    /**
     * 审核内容
     */
    private String shnr;

    /**
     * 审核时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date shsj;

    /**
     * 诉求人证件id
     */
    private String sqrzjid;

    /**
     * 诉求人邮箱地址
     */
    private String email;

    /**
     * 验证码
     */
    private String yzm;

    /**
     * 登记中心
     */
    private String djzx;

}
