package cn.gtmap.hlw.core.dto.forward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 请求转发参数DTO
 *
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a
 * @version 1.0
 * @description 封装转发请求的所有参数，包括目标地址、请求头、参数等
 */
@Data
@ApiModel("请求转发参数")
public class ForwardRequestDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "目标URL地址", required = true, example = "https://api.example.com/data")
    @NotBlank(message = "目标URL不能为空")
    private String targetUrl;

    @ApiModelProperty(value = "HTTP请求方法(GET/POST)", example = "POST")
    private String method = "POST";

    @ApiModelProperty(value = "请求头信息", example = "{\"Content-Type\":\"application/json\"}")
    private Map<String, String> headers;

    @ApiModelProperty(value = "Query参数", example = "{\"page\":\"1\",\"size\":\"10\"}")
    private Map<String, String> queryParams;

    @ApiModelProperty(value = "请求体内容(POST请求使用)", example = "{\"name\":\"test\"}")
    private String body;

    @ApiModelProperty(value = "请求超时时间(毫秒)", example = "30000")
    private Integer timeout = 30000;

    @ApiModelProperty(value = "是否保留原始响应状态码", example = "true")
    private Boolean keepOriginalStatus = true;

    @ApiModelProperty(value = "字符编码", example = "UTF-8")
    private String charset = "UTF-8";

    @ApiModelProperty(value = "Content-Type", example = "application/json")
    private String contentType;
}

